/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.osd.storage.VersionTable;

public class FileMetadata {
    private Map<Long, Long> latestObjVersions;
    private Map<Long, Long> largestObjVersions;
    private Map<Long, Map<Long, Long>> objChecksums;
    private long filesize;
    private long lastObjectNumber;
    private long globalLastObjectNumber;
    private long truncateEpoch;
    private final StripingPolicyImpl stripingPolicy;
    private VersionTable versionTable;
    private RandomAccessFile[] handles;
    private long mdFileLength;

    public FileMetadata(StripingPolicyImpl sp) {
        this.stripingPolicy = sp;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    public long getLastObjectNumber() {
        return this.lastObjectNumber;
    }

    public void setLastObjectNumber(long lastObjectNumber) {
        this.lastObjectNumber = lastObjectNumber;
    }

    public long getLargestObjectVersion(long objId) {
        Long v = this.largestObjVersions.get(objId);
        return v == null ? 0L : v;
    }

    public long getLatestObjectVersion(long objId) {
        Long v = this.latestObjVersions.get(objId);
        return v == null ? 0L : v;
    }

    public Long getObjectChecksum(long objId, long objVer) {
        Map<Long, Long> checksums = this.objChecksums.get(objId);
        if (checksums == null) {
            return 0L;
        }
        Long c = checksums.get(objVer);
        return c == null ? 0L : c;
    }

    public Set<Map.Entry<Long, Long>> getLatestObjectVersions() {
        return this.latestObjVersions.entrySet();
    }

    public void clearLatestObjectVersions() {
        this.latestObjVersions.clear();
    }

    public void initLargestObjectVersions(Map<Long, Long> largestObjVersions) {
        assert (this.largestObjVersions == null);
        this.largestObjVersions = largestObjVersions;
    }

    public void initLatestObjectVersions(Map<Long, Long> latestObjVersions) {
        assert (this.latestObjVersions == null);
        this.latestObjVersions = latestObjVersions;
    }

    public void initObjectChecksums(Map<Long, Map<Long, Long>> objChecksums) {
        assert (this.objChecksums == null);
        this.objChecksums = objChecksums;
    }

    public void initVersionTable(VersionTable versionTable) {
        assert (this.versionTable == null);
        this.versionTable = versionTable;
    }

    public void updateObjectVersion(long objId, long newVersion) {
        this.latestObjVersions.put(objId, newVersion);
        if (this.largestObjVersions != this.latestObjVersions && newVersion != 0L) {
            this.largestObjVersions.put(objId, newVersion);
        }
    }

    public void updateObjectChecksum(long objId, long objVer, long newChecksum) {
        Map<Long, Long> checksums = this.objChecksums.get(objId);
        if (checksums == null) {
            checksums = new HashMap<Long, Long>();
            this.objChecksums.put(objId, checksums);
        }
        checksums.put(objVer, newChecksum);
    }

    public void discardObject(long objId, long objVer) {
        this.latestObjVersions.remove(objId);
        this.objChecksums.remove(objId + "." + objVer);
    }

    public String toString() {
        return "(fileSize=" + this.filesize + ", lastObjNo=" + this.lastObjectNumber + ")";
    }

    public long getTruncateEpoch() {
        return this.truncateEpoch;
    }

    public void setTruncateEpoch(long truncateEpoch) {
        this.truncateEpoch = truncateEpoch;
    }

    public long getGlobalLastObjectNumber() {
        return this.globalLastObjectNumber;
    }

    public void setGlobalLastObjectNumber(long globalLastObjectNumber) {
        this.globalLastObjectNumber = globalLastObjectNumber;
    }

    public StripingPolicyImpl getStripingPolicy() {
        return this.stripingPolicy;
    }

    public VersionTable getVersionTable() {
        return this.versionTable;
    }

    public RandomAccessFile[] getHandles() {
        return this.handles;
    }

    public void setHandles(RandomAccessFile[] handles) {
        this.handles = handles;
    }

    public long getMdFileLength() {
        return this.mdFileLength;
    }

    public void setMdFileLength(long mdFileLength) {
        this.mdFileLength = mdFileLength;
    }
}

