/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.foundation.LRUCache;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.checksums.ChecksumAlgorithm;
import org.xtreemfs.foundation.checksums.ChecksumFactory;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.OSDConfig;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.osd.storage.VersionTable;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class HashStorageLayout
extends StorageLayout {
    public static final String TEPOCH_FILENAME = ".tepoch";
    public static final String MASTER_EPOCH_FILENAME = ".mepoch";
    public static final String TRUNCATE_LOG_FILENAME = ".tlog";
    public static final String VTABLE_FILENAME = ".vtable";
    public static final String CURRENT_VER_FILENAME = ".curr_file_ver";
    public static final String XLOC_VERSION_STATE_FILENAME = ".version_state";
    public static final int SL_TAG = 2;
    public static final String JAVA_HASH = "Java-Hash";
    public static final String SDBM_HASH = "SDBM";
    public static final int SUBDIRS_16 = 15;
    public static final int SUBDIRS_256 = 255;
    public static final int SUBDIRS_4096 = 4095;
    public static final int SUBDIRS_65535 = 65534;
    public static final int SUBDIRS_1048576 = 1048575;
    public static final int SUBDIRS_16777216 = 0xFFFFFF;
    public static final String DEFAULT_HASH = "Java-Hash";
    private static final int DEFAULT_SUBDIRS = 255;
    private static final int DEFAULT_MAX_DIR_DEPTH = 4;
    private int prefixLength;
    private int hashCutLength;
    private ChecksumAlgorithm checksumAlgo;
    private long _stat_fileInfoLoads;
    private final boolean checksumsEnabled;
    private final LRUCache<String, String> hashedPathCache;
    private static final boolean USE_PATH_CACHE = true;
    private static final int RETRIES_INCOMPLETE_READ = 2;
    private static final String ERROR_MESSAGE_INCOMPLETE_READ = "Failed to read the requested number of bytes from the file on disk. Maybe there's a media error or the file was modified outside the scope of the OSD by another process?";
    private final LRUCache<String, OSD.XLocSetVersionState> xLocSetVSCache;

    public HashStorageLayout(OSDConfig config, MetadataCache cache) throws IOException {
        this(config, cache, "Java-Hash", 255, 4);
    }

    public HashStorageLayout(OSDConfig config, MetadataCache cache, String hashAlgo, int maxSubdirsPerDir, int maxDirDepth) throws IOException {
        super(config, cache);
        this.checksumsEnabled = config.isUseChecksums();
        if (config.isUseChecksums()) {
            try {
                this.checksumAlgo = ChecksumFactory.getInstance().getAlgorithm(config.getChecksumProvider());
                if (this.checksumAlgo == null) {
                    throw new NoSuchAlgorithmException("algo is null");
                }
            }
            catch (NoSuchAlgorithmException e) {
                Logging.logMessage(3, Logging.Category.storage, this, "could not instantiate checksum algorithm '%s'", config.getChecksumProvider());
                Logging.logMessage(3, Logging.Category.storage, this, "OSD checksums will be switched off", new Object[0]);
            }
        }
        this.prefixLength = maxSubdirsPerDir != 0 ? Integer.toHexString(maxSubdirsPerDir).length() : Integer.toHexString(255).length();
        this.hashCutLength = maxDirDepth != 0 ? maxDirDepth * this.prefixLength : 4 * this.prefixLength;
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "initialized with checksums=%s prefixLen=%d", this.checksumsEnabled, this.prefixLength);
        }
        this._stat_fileInfoLoads = 0L;
        this.hashedPathCache = new LRUCache(2048);
        this.xLocSetVSCache = new LRUCache(2048);
    }

    @Override
    public ObjectInformation readObject(String fileId, FileMetadata md, long objNo, int offset, int length, long version) throws IOException {
        File file;
        int stripeSize = md.getStripingPolicy().getStripeSizeForObject(objNo);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.storage, this, "fetching object %s-%d from disk", fileId, objNo);
        }
        ReusableBuffer bbuf = null;
        boolean checkChecksum = false;
        if (length == -1) {
            assert (offset == 0) : "if length is -1 offset must be 0 but is " + offset;
            length = stripeSize;
            if (this.checksumsEnabled) {
                checkChecksum = true;
            }
        }
        if (version == 0L) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.storage, this, "object does not exist (according to md cache)", new Object[0]);
            }
            return new ObjectInformation(ObjectInformation.ObjectStatus.DOES_NOT_EXIST, null, stripeSize);
        }
        long oldChecksum = md.getObjectChecksum(objNo, version);
        String fileName = this.generateAbsoluteObjectPathFromFileId(fileId, objNo, version, oldChecksum);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.storage, this, "path to object on disk: %s", fileName);
        }
        if ((file = new File(fileName)).exists()) {
            RandomAccessFile f = new RandomAccessFile(file, "r");
            int flength = (int)f.length();
            try {
                if (flength == 0) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.storage, this, "object %d is a padding object", objNo);
                    }
                    ObjectInformation objectInformation = new ObjectInformation(ObjectInformation.ObjectStatus.PADDING_OBJECT, null, stripeSize);
                    return objectInformation;
                }
                if (flength <= offset) {
                    bbuf = BufferPool.allocate(0);
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.storage, this, "object %d is read at an offset beyond its size", objNo);
                    }
                    ObjectInformation objectInformation = new ObjectInformation(ObjectInformation.ObjectStatus.EXISTS, bbuf, stripeSize);
                    return objectInformation;
                }
                int lastoffset = offset + length;
                assert (lastoffset <= stripeSize);
                if (lastoffset > flength) {
                    assert (flength - offset > 0);
                    bbuf = BufferPool.allocate(flength - offset);
                } else {
                    bbuf = BufferPool.allocate(length);
                }
                for (int attempt = 0; attempt <= 2; ++attempt) {
                    if (attempt > 0) {
                        bbuf.position(0);
                        Logging.logMessage(6, Logging.Category.storage, this, "Retrying to read object from disk since it failed before (retry %d/%d). Path to the file on disk: %s", attempt, 2, fileName);
                    }
                    f.getChannel().position(offset);
                    f.getChannel().read(bbuf.getBuffer());
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.storage, this, "object %d is read at offset %d, %d bytes read, attempt: %d", objNo, offset, bbuf.limit(), attempt);
                    }
                    if (bbuf.hasRemaining()) {
                        if (attempt == 0) {
                            Logging.logMessage(3, Logging.Category.storage, this, "%s Path to the file on disk: %s", ERROR_MESSAGE_INCOMPLETE_READ, fileName);
                        }
                    } else {
                        if (attempt <= 0) break;
                        Logging.logMessage(3, Logging.Category.storage, this, "Successfully read object from disk at retry %d after previous failures. Path to the file on disk: %s", attempt, fileName);
                        break;
                    }
                    if (attempt != 2) continue;
                    throw new IOException(ERROR_MESSAGE_INCOMPLETE_READ);
                }
                f.close();
                bbuf.position(0);
                ObjectInformation oInfo = new ObjectInformation(ObjectInformation.ObjectStatus.EXISTS, bbuf, stripeSize);
                if (checkChecksum) {
                    ReusableBuffer bbufCopy = bbuf.createViewBuffer();
                    this.checksumAlgo.reset();
                    this.checksumAlgo.update(bbufCopy.getBuffer());
                    BufferPool.free(bbufCopy);
                    long newChecksum = this.checksumAlgo.getValue();
                    oInfo.setChecksumInvalidOnOSD(newChecksum != oldChecksum);
                }
                ObjectInformation objectInformation = oInfo;
                return objectInformation;
            }
            catch (Exception e) {
                if (bbuf != null) {
                    BufferPool.free(bbuf);
                }
                if (e instanceof IOException) {
                    Logging.logMessage(3, Logging.Category.storage, this, "Failed to read object file from disk. Error: %s Path to the file on disk: %s", e.getMessage(), fileName);
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            finally {
                f.close();
            }
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.storage, this, "object %d does not exist", objNo);
        }
        return new ObjectInformation(ObjectInformation.ObjectStatus.DOES_NOT_EXIST, null, stripeSize);
    }

    @Override
    public void writeObject(String fileId, FileMetadata md, ReusableBuffer data, long objNo, int offset, long newVersion, boolean sync, boolean cow) throws IOException {
        assert (newVersion > 0L) : "object version must be > 0";
        if (data.capacity() == 0) {
            return;
        }
        String relPath = this.generateRelativeFilePath(fileId);
        new File(this.storageDir + relPath).mkdirs();
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.storage, this, "writing object %s-%d to disk: %s", fileId, objNo, relPath);
        }
        try {
            boolean isRangeWrite;
            boolean bl = isRangeWrite = offset > 0 || data.capacity() < md.getStripingPolicy().getStripeSizeForObject(objNo);
            if (isRangeWrite) {
                if (cow || this.checksumsEnabled) {
                    this.partialWriteCOW(relPath, fileId, md, data, offset, objNo, newVersion, sync, !cow);
                } else {
                    this.partialWriteNoCOW(relPath, fileId, md, data, objNo, offset, newVersion, sync);
                }
            } else {
                this.completeWrite(relPath, fileId, md, data, objNo, newVersion, sync, !cow);
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("unable to create file directory or object: " + ex.getMessage());
        }
    }

    private void partialWriteCOW(String relativePath, String fileId, FileMetadata md, ReusableBuffer data, int offset, long objNo, long newVersion, boolean sync, boolean deleteOldVersion) throws IOException {
        assert (data != null);
        long oldVersion = md.getLatestObjectVersion(objNo);
        long oldChecksum = md.getObjectChecksum(objNo, oldVersion);
        ReusableBuffer fullObj = this.cow(fileId, md, objNo, data, offset, oldVersion);
        long newChecksum = 0L;
        if (this.checksumsEnabled) {
            this.checksumAlgo.reset();
            this.checksumAlgo.update(fullObj.getBuffer());
            newChecksum = this.checksumAlgo.getValue();
        }
        String newFilename = this.generateAbsoluteObjectPathFromRelPath(relativePath, objNo, newVersion, newChecksum);
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "writing to file (COW): %s", newFilename);
        }
        File file = new File(newFilename);
        String mode = sync ? "rwd" : "rw";
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file, mode);
            fullObj.position(0);
            f.getChannel().write(fullObj.getBuffer());
        }
        catch (IOException e) {
            Logging.logMessage(3, Logging.Category.storage, this, "Failed to write object file to disk. Error: %s Path to the file on disk: %s", e.getMessage(), newFilename);
            throw e;
        }
        finally {
            if (f != null) {
                f.close();
            }
            BufferPool.free(fullObj);
        }
        if (deleteOldVersion) {
            String oldFilename = this.generateAbsoluteObjectPathFromRelPath(relativePath, objNo, oldVersion, oldChecksum);
            File oldFile = new File(oldFilename);
            oldFile.delete();
        }
        md.updateObjectVersion(objNo, newVersion);
        md.updateObjectChecksum(objNo, newVersion, newChecksum);
    }

    private void partialWriteNoCOW(String relativePath, String fileId, FileMetadata md, ReusableBuffer data, long objNo, int offset, long newVersion, boolean sync) throws IOException {
        assert (!this.checksumsEnabled);
        long oldVersion = md.getLatestObjectVersion(objNo);
        String filename = this.generateAbsoluteObjectPathFromRelPath(relativePath, objNo, oldVersion, 0L);
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "writing to file: %s", filename);
        }
        File file = new File(filename);
        String mode = sync ? "rwd" : "rw";
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file, mode);
            data.position(0);
            f.seek(offset);
            f.getChannel().write(data.getBuffer());
        }
        catch (IOException e) {
            Logging.logMessage(3, Logging.Category.storage, this, "Failed to write object file to disk. Error: %s Path to the file on disk: %s", e.getMessage(), filename);
            throw e;
        }
        finally {
            if (f != null) {
                f.close();
            }
            BufferPool.free(data);
        }
        if (newVersion != oldVersion) {
            String newFilename = this.generateAbsoluteObjectPathFromRelPath(relativePath, objNo, newVersion, 0L);
            file.renameTo(new File(newFilename));
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "renamed to: %s", newFilename);
            }
            md.updateObjectVersion(objNo, newVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeWrite(String relativePath, String fileId, FileMetadata md, ReusableBuffer data, long objNo, long newVersion, boolean sync, boolean deleteOldVersion) throws IOException {
        long oldVersion = md.getLatestObjectVersion(objNo);
        long oldChecksum = md.getObjectChecksum(objNo, oldVersion);
        long newChecksum = 0L;
        if (this.checksumsEnabled) {
            this.checksumAlgo.reset();
            this.checksumAlgo.update(data.getBuffer());
            newChecksum = this.checksumAlgo.getValue();
        }
        String newFilename = this.generateAbsoluteObjectPathFromRelPath(relativePath, objNo, newVersion, newChecksum);
        if (Logging.isDebug()) {
            Logging.logMessage(7, this, "writing to file: %s", newFilename);
        }
        File file = new File(newFilename);
        String mode = sync ? "rwd" : "rw";
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file, mode);
            data.position(0);
            f.getChannel().write(data.getBuffer());
        }
        finally {
            if (f != null) {
                f.close();
            }
            BufferPool.free(data);
        }
        if ((oldVersion != newVersion || newChecksum != oldChecksum) && deleteOldVersion) {
            String oldFilename = this.generateAbsoluteObjectPathFromRelPath(relativePath, objNo, oldVersion, oldChecksum);
            File oldFile = new File(oldFilename);
            oldFile.delete();
        }
        md.updateObjectVersion(objNo, newVersion);
        if (this.checksumsEnabled) {
            md.updateObjectChecksum(objNo, newVersion, newChecksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentObjVersion(String fileId, long objNo, long newVersion) throws IOException {
        File file = new File(this.generateAbsoluteFilePath(fileId), CURRENT_VER_FILENAME);
        if (!file.exists()) {
            file.createNewFile();
        }
        RandomAccessFile versionFile = null;
        try {
            versionFile = new RandomAccessFile(file, "rw");
            versionFile.seek(objNo * 64L / 8L);
            versionFile.writeLong(newVersion);
        }
        finally {
            if (versionFile != null) {
                versionFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentVersionSize(String fileId, long newLastObject) throws IOException {
        File file = new File(this.generateAbsoluteFilePath(fileId), CURRENT_VER_FILENAME);
        if (!file.exists()) {
            file.createNewFile();
        }
        RandomAccessFile versionFile = null;
        try {
            versionFile = new RandomAccessFile(file, "rw");
            versionFile.setLength((newLastObject + 1L) * 64L / 8L);
        }
        finally {
            versionFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateObject(String fileId, FileMetadata md, long objNo, int newLength, long newVersion, boolean cow) throws IOException {
        long oldVersion = md.getLatestObjectVersion(objNo);
        long oldChecksum = md.getObjectChecksum(objNo, oldVersion);
        assert (newLength <= md.getStripingPolicy().getStripeSizeForObject(objNo));
        String oldFileName = this.generateAbsoluteObjectPathFromFileId(fileId, objNo, oldVersion, oldChecksum);
        File oldFile = new File(oldFileName);
        long currentLength = oldFile.length();
        String mode = "rw";
        if ((long)newLength == currentLength) {
            return;
        }
        if (cow || this.checksumsEnabled) {
            ReusableBuffer oldData = this.unwrapObjectData(fileId, md, objNo, oldVersion);
            if (newLength < oldData.capacity()) {
                oldData.range(0, newLength);
            } else {
                ReusableBuffer newData = BufferPool.allocate(newLength);
                newData.put(oldData);
                while (newData.hasRemaining()) {
                    newData.put((byte)0);
                }
                BufferPool.free(oldData);
                oldData = newData;
            }
            oldData.position(0);
            long newChecksum = 0L;
            if (this.checksumsEnabled) {
                this.checksumAlgo.update(oldData.getBuffer());
                newChecksum = this.checksumAlgo.getValue();
            }
            if (!cow) {
                oldFile.delete();
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.storage, this, "truncate object %d, delete old version %d: %s", objNo, oldVersion, oldFileName);
                }
            }
            String newFilename = this.generateAbsoluteObjectPathFromFileId(fileId, objNo, newVersion, newChecksum);
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(newFilename, mode);
                raf.getChannel().write(oldData.getBuffer());
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
                BufferPool.free(oldData);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.storage, this, "truncate object %d, wrote new version %d: %s", objNo, newVersion, newFilename);
            }
            md.updateObjectVersion(objNo, newVersion);
            if (this.checksumsEnabled) {
                md.updateObjectChecksum(objNo, newVersion, newChecksum);
            }
        } else {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(oldFile, mode);
                raf.setLength(newLength);
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
            if (newVersion != oldVersion) {
                String newFilename = this.generateAbsoluteObjectPathFromFileId(fileId, objNo, newVersion, 0L);
                oldFile.renameTo(new File(newFilename));
                md.updateObjectVersion(objNo, newVersion);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.storage, this, "truncate object %d, renamed file for new version %d: %s", objNo, newVersion, newFilename);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPaddingObject(String fileId, FileMetadata md, long objNo, long version, int size) throws IOException {
        assert (size >= 0) : "size is " + size;
        String relPath = this.generateRelativeFilePath(fileId);
        new File(this.storageDir + relPath).mkdirs();
        long checksum = 0L;
        if (this.checksumAlgo != null) {
            byte[] content = new byte[size];
            this.checksumAlgo.update(ByteBuffer.wrap(content));
            checksum = this.checksumAlgo.getValue();
        }
        String filename = this.generateAbsoluteObjectPathFromRelPath(relPath, objNo, version, checksum);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "rw");
            raf.setLength(size);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        md.updateObjectVersion(objNo, version);
        if (this.checksumsEnabled) {
            md.updateObjectChecksum(objNo, version, checksum);
        }
    }

    @Override
    public void deleteFile(String fileId, final boolean deleteMetadata) throws IOException {
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        File[] fileList = fileDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return deleteMetadata || !pathname.getName().startsWith(".");
            }
        });
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            file.delete();
        }
        if (deleteMetadata) {
            this.del(fileDir);
        }
    }

    private void del(File parent) {
        File storageDirFile = new File(this.storageDir);
        for (File p = parent; p != null && p.list().length <= 1 && !p.equals(storageDirFile); p = p.getParentFile()) {
            parent.delete();
        }
    }

    @Override
    public void deleteObject(String fileId, FileMetadata md, final long objNo, long version) throws IOException {
        File[] objs;
        final long verToDel = version == -1L ? md.getLatestObjectVersion(objNo) : version;
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        for (File obj : objs = fileDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith(".")) {
                    return false;
                }
                ObjFileData ofd = HashStorageLayout.parseFileName(pathname.getName());
                return ofd.objNo == objNo && ofd.objVersion == verToDel;
            }
        })) {
            obj.delete();
        }
    }

    @Override
    public boolean fileExists(String fileId) {
        File dir = new File(this.generateAbsoluteFilePath(fileId));
        return dir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileMetadata loadFileMetadata(String fileId, StripingPolicyImpl sp) throws IOException {
        this._stat_fileInfoLoads = 0L;
        FileMetadata info = new FileMetadata(sp);
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        if (fileDir.exists()) {
            String[] objs;
            HashMap<Long, Long> largestObjVersions = new HashMap<Long, Long>();
            HashMap<Long, Map<Long, Long>> objChecksums = new HashMap<Long, Map<Long, Long>>();
            HashMap<Long, Long> latestObjVersions = null;
            long lastObjNum = -1L;
            String lastObject = null;
            File currVerFile = new File(fileDir, CURRENT_VER_FILENAME);
            boolean multiVersionSupport = currVerFile.exists();
            if (multiVersionSupport) {
                latestObjVersions = new HashMap<Long, Long>();
                RandomAccessFile rf = new RandomAccessFile(currVerFile, "r");
                long l = 0L;
                while (true) {
                    block26: {
                        try {
                            long objVer = rf.readLong();
                            if (objVer == 0L) break block26;
                            latestObjVersions.put(l, objVer);
                        }
                        catch (EOFException exc) {
                            lastObjNum = l - 1L;
                            break;
                        }
                    }
                    ++l;
                }
                rf.close();
            }
            for (String obj : objs = fileDir.list()) {
                if (obj.startsWith(".")) continue;
                ObjFileData ofd = HashStorageLayout.parseFileName(obj);
                if (ofd.checksum != 0L) {
                    HashMap<Long, Long> checksums = (HashMap<Long, Long>)objChecksums.get(ofd.objNo);
                    if (checksums == null) {
                        checksums = new HashMap<Long, Long>();
                        objChecksums.put(ofd.objNo, checksums);
                    }
                    checksums.put(ofd.objVersion, ofd.checksum);
                }
                if (multiVersionSupport) {
                    Long latestObjVer = (Long)latestObjVersions.get(ofd.objNo);
                    if (ofd.objNo == lastObjNum && latestObjVer != null && ofd.objVersion == latestObjVer) {
                        lastObject = obj;
                    }
                } else if (ofd.objNo > lastObjNum) {
                    lastObject = obj;
                    lastObjNum = ofd.objNo;
                }
                Long oldver = (Long)largestObjVersions.get(ofd.objNo);
                if (oldver != null && oldver >= ofd.objVersion) continue;
                largestObjVersions.put(ofd.objNo, ofd.objVersion);
            }
            if (multiVersionSupport) {
                info.initLatestObjectVersions(latestObjVersions);
                info.initLargestObjectVersions(largestObjVersions);
            } else {
                info.initLatestObjectVersions(largestObjVersions);
                info.initLargestObjectVersions(largestObjVersions);
            }
            info.initObjectChecksums(objChecksums);
            if (lastObjNum > -1L) {
                File lastObjFile = new File(fileDir.getAbsolutePath() + "/" + lastObject);
                long lastObjSize = lastObjFile.length();
                if (lastObjSize == 0L) {
                    lastObjSize = sp.getStripeSizeForObject(lastObjSize);
                }
                long fsize = lastObjSize;
                if (lastObjNum > 0L) {
                    fsize += sp.getObjectEndOffset(lastObjNum - 1L) + 1L;
                }
                assert (fsize >= 0L);
                info.setFilesize(fsize);
                info.setLastObjectNumber(lastObjNum);
            } else {
                info.setFilesize(0L);
                info.setLastObjectNumber(-1L);
            }
            File tepoch = new File(fileDir, TEPOCH_FILENAME);
            if (tepoch.exists()) {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(tepoch, "r");
                    info.setTruncateEpoch(raf.readLong());
                }
                finally {
                    if (raf != null) {
                        raf.close();
                    }
                }
            }
            File vtFile = new File(fileDir, VTABLE_FILENAME);
            VersionTable vt = new VersionTable(vtFile);
            if (vtFile.exists()) {
                vt.load();
            }
            info.initVersionTable(vt);
        } else {
            info.setFilesize(0L);
            info.setLastObjectNumber(-1L);
            info.initLatestObjectVersions(new HashMap<Long, Long>());
            info.initLargestObjectVersions(new HashMap<Long, Long>());
            info.initObjectChecksums(new HashMap<Long, Map<Long, Long>>());
            info.initVersionTable(new VersionTable(new File(fileDir, VTABLE_FILENAME)));
        }
        info.setGlobalLastObjectNumber(-1L);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTruncateEpoch(String fileId, long newTruncateEpoch) throws IOException {
        File parent = new File(this.generateAbsoluteFilePath(fileId));
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File tepoch = new File(parent, TEPOCH_FILENAME);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(tepoch, "rw");
            raf.writeLong(newTruncateEpoch);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    @Override
    public ObjectSet getObjectSet(String fileId, FileMetadata md) {
        ObjectSet objectSet;
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        if (fileDir.exists()) {
            String[] objs = fileDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.startsWith(".");
                }
            });
            objectSet = new ObjectSet(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                objectSet.add(HashStorageLayout.parseFileName((String)objs[i]).objNo);
            }
        } else {
            objectSet = new ObjectSet(0);
        }
        return objectSet;
    }

    public String generateAbsoluteFilePath(String fileId) {
        return this.storageDir + this.generateRelativeFilePath(fileId);
    }

    private String generateAbsoluteObjectPathFromFileId(String fileId, long objNo, long version, long checksum) {
        StringBuilder path = new StringBuilder(this.generateAbsoluteFilePath(fileId));
        path.append(HashStorageLayout.createFileName(objNo, version, checksum));
        return path.toString();
    }

    private String generateAbsoluteObjectPathFromRelPath(String relativeFilePath, long objNo, long version, long checksum) {
        StringBuilder path = new StringBuilder(this.storageDir);
        path.append(relativeFilePath);
        path.append(HashStorageLayout.createFileName(objNo, version, checksum));
        return path.toString();
    }

    private String generateRelativeFilePath(String fileId) {
        String cached = (String)this.hashedPathCache.get(fileId);
        if (cached != null) {
            return cached;
        }
        String id = WIN ? fileId.replace(':', '_') : fileId;
        StringBuilder path = this.generateHashPath(id);
        path.append(id);
        path.append("/");
        String pathStr = path.toString();
        this.hashedPathCache.put(fileId, pathStr);
        return pathStr;
    }

    private StringBuilder generateHashPath(String fileId) {
        int j;
        StringBuilder hashPath = new StringBuilder(128);
        String hash = this.hash(fileId);
        int i = 0;
        for (j = this.prefixLength; j < hash.length(); j += this.prefixLength) {
            hashPath.append(hash.subSequence(i, j));
            hashPath.append("/");
            i += this.prefixLength;
        }
        if (j < hash.length() + this.prefixLength) {
            hashPath.append(hash.subSequence(i, hash.length()));
            hashPath.append("/");
        }
        return hashPath;
    }

    private String hash(String str) {
        assert (str != null);
        StringBuffer sb = new StringBuffer(16);
        long hashValue = str.hashCode();
        OutputUtils.writeHexLong(sb, hashValue);
        if (sb.length() > this.hashCutLength) {
            return sb.substring(0, this.hashCutLength);
        }
        return sb.toString();
    }

    @Override
    public long getFileInfoLoadCount() {
        return this._stat_fileInfoLoads;
    }

    private long getVersion(File f) throws NumberFormatException {
        String name = f.getName();
        ObjFileData ofd = HashStorageLayout.parseFileName(name);
        return ofd.objVersion;
    }

    private long getObjectNo(File f) throws NumberFormatException {
        String name = f.getName();
        ObjFileData ofd = HashStorageLayout.parseFileName(name);
        return ofd.objNo;
    }

    public static String createFileName(long objNo, long objVersion, long checksum) {
        StringBuffer sb = new StringBuffer(24);
        OutputUtils.writeHexLong(sb, objNo);
        OutputUtils.writeHexLong(sb, objVersion);
        OutputUtils.writeHexLong(sb, checksum);
        return sb.toString();
    }

    public static ObjFileData parseFileName(String filename) {
        if (filename.length() == 32) {
            long objNo = OutputUtils.readHexLong(filename, 0);
            int objVersion = OutputUtils.readHexInt(filename, 16);
            long checksum = OutputUtils.readHexLong(filename, 24);
            return new ObjFileData(objNo, objVersion, checksum);
        }
        long objNo = OutputUtils.readHexLong(filename, 0);
        long objVersion = OutputUtils.readHexLong(filename, 16);
        long checksum = OutputUtils.readHexLong(filename, 32);
        return new ObjFileData(objNo, objVersion, checksum);
    }

    @Override
    public int getLayoutVersionTag() {
        return 2;
    }

    @Override
    public boolean isCompatibleVersion(int layoutVersionTag) {
        if (layoutVersionTag == 2) {
            return true;
        }
        return layoutVersionTag == 1;
    }

    @Override
    public StorageLayout.FileList getFileList(StorageLayout.FileList l, int maxNumEntries) {
        if (l == null) {
            l = new StorageLayout.FileList(new Stack<String>(), new HashMap<String, StorageLayout.FileData>());
            l.status.push("");
        }
        l.files.clear();
        try {
            do {
                int PREVIEW_LENGTH = 15;
                String currentDir = l.status.pop();
                File dir = new File(this.storageDir + currentDir);
                if (dir.listFiles() == null) {
                    Logging.logMessage(4, Logging.Category.misc, this, this.storageDir + currentDir + " is not a valid directory!", new Object[0]);
                    continue;
                }
                File newestFirst = null;
                File newestLast = null;
                Long objectSize = 0L;
                boolean isFileNameDir = false;
                for (File ch : dir.listFiles()) {
                    if (ch != null && ch.isDirectory()) {
                        l.status.push(currentDir + "/" + ch.getName());
                        continue;
                    }
                    if (ch != null && ch.isFile() && !ch.getName().contains(".") && !ch.getName().endsWith(".ser")) {
                        try {
                            long version = this.getVersion(ch);
                            long objNum = this.getObjectNo(ch);
                            isFileNameDir = true;
                            if (newestFirst == null) {
                                newestFirst = newestLast = ch;
                                objectSize = ch.length();
                                continue;
                            }
                            if (version > this.getVersion(newestFirst)) {
                                newestFirst = newestLast = ch;
                                objectSize = objectSize >= ch.length() ? objectSize.longValue() : ch.length();
                                continue;
                            }
                            if (version != this.getVersion(newestFirst)) continue;
                            if (objNum < this.getObjectNo(newestFirst)) {
                                newestFirst = ch;
                            } else if (objNum > this.getObjectNo(newestLast)) {
                                newestLast = ch;
                            }
                            objectSize = objectSize >= ch.length() ? objectSize.longValue() : ch.length();
                        }
                        catch (Exception e) {
                            Logging.logMessage(4, Logging.Category.storage, this, "CleanUp: an illegal file (" + ch.getAbsolutePath() + ") was discovered and ignored.", new Object[0]);
                        }
                        continue;
                    }
                    if (ch == null || !ch.isFile() || !ch.getName().endsWith(XLOC_VERSION_STATE_FILENAME)) continue;
                    isFileNameDir = true;
                }
                if (!isFileNameDir) continue;
                if (newestFirst != null) {
                    block18: {
                        char[] preview = null;
                        try {
                            FileReader fReader = new FileReader(newestFirst);
                            preview = new char[PREVIEW_LENGTH];
                            fReader.read(preview);
                            fReader.close();
                        }
                        catch (Exception e) {
                            if ($assertionsDisabled) break block18;
                            throw new AssertionError();
                        }
                    }
                    long stripCount = this.getObjectNo(newestLast);
                    long fileSize = stripCount == 1L ? newestFirst.length() : objectSize * stripCount + newestLast.length();
                    l.files.put(WIN ? dir.getName().replace('_', ':') : dir.getName(), new StorageLayout.FileData(fileSize, (int)(objectSize / 1024L)));
                    continue;
                }
                l.files.put(WIN ? dir.getName().replace('_', ':') : dir.getName(), new StorageLayout.FileData(true));
            } while (l.files.size() < maxNumEntries);
            l.hasMore = true;
            return l;
        }
        catch (EmptyStackException ex) {
            l.hasMore = false;
            return l;
        }
    }

    @Override
    public ArrayList<String> getFileIDList() {
        ArrayList<String> fileList = new ArrayList<String>();
        Stack<String> directories = new Stack<String>();
        directories.push(this.storageDir);
        while (!directories.empty()) {
            File currentFile = new File((String)directories.pop());
            for (File f : currentFile.listFiles()) {
                if (f != null && f.isDirectory() && !f.getName().contains(":")) {
                    directories.push(f.getAbsolutePath());
                    continue;
                }
                if (f == null || f.getName().contains(".") || f.getName().endsWith(".ser")) continue;
                fileList.add(f.getName());
            }
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMasterEpoch(String fileId) throws IOException {
        int masterEpoch = 0;
        RandomAccessFile raf = null;
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        File mepoch = new File(fileDir, MASTER_EPOCH_FILENAME);
        try {
            raf = new RandomAccessFile(mepoch, "r");
            masterEpoch = raf.readInt();
        }
        catch (FileNotFoundException ex) {
            String oldFileId = "/" + fileId;
            File oldFileDir = new File(this.generateAbsoluteFilePath(oldFileId));
            File oldMepoch = new File(oldFileDir, MASTER_EPOCH_FILENAME);
            if (oldMepoch.isFile()) {
                if (!fileDir.exists()) {
                    fileDir.mkdirs();
                }
                if (oldMepoch.renameTo(mepoch)) {
                    this.del(oldFileDir);
                    raf = new RandomAccessFile(mepoch, "r");
                } else {
                    Logging.logMessage(4, this, "Failed to move %s file from: %s to: %s", MASTER_EPOCH_FILENAME, oldFileDir.getPath(), fileDir.getPath());
                    raf = new RandomAccessFile(oldMepoch, "r");
                }
                masterEpoch = raf.readInt();
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        return masterEpoch;
    }

    @Override
    public void setMasterEpoch(String fileId, int masterEpoch) throws IOException {
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        File mepoch = new File(fileDir, MASTER_EPOCH_FILENAME);
        RandomAccessFile rf = new RandomAccessFile(mepoch, "rw");
        rf.writeInt(masterEpoch);
        rf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSD.TruncateLog getTruncateLog(String fileId) throws IOException {
        OSD.TruncateLog.Builder tlbuilder = OSD.TruncateLog.newBuilder();
        try {
            File fileDir = new File(this.generateAbsoluteFilePath(fileId));
            File tlog = new File(fileDir, TRUNCATE_LOG_FILENAME);
            FileInputStream input = null;
            try {
                input = new FileInputStream(tlog);
                tlbuilder.mergeDelimitedFrom(input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tlbuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTruncateLog(String fileId, OSD.TruncateLog log) throws IOException {
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        File tlog = new File(fileDir, TRUNCATE_LOG_FILENAME);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(tlog);
            log.writeDelimitedTo(output);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSD.XLocSetVersionState getXLocSetVersionState(String fileId) throws IOException {
        OSD.XLocSetVersionState state = (OSD.XLocSetVersionState)this.xLocSetVSCache.get(fileId);
        if (state == null) {
            OSD.XLocSetVersionState.Builder vsbuilder = OSD.XLocSetVersionState.newBuilder();
            File fileDir = new File(this.generateAbsoluteFilePath(fileId));
            File vsFile = new File(fileDir, XLOC_VERSION_STATE_FILENAME);
            FileInputStream input = null;
            try {
                input = new FileInputStream(vsFile);
                vsbuilder.mergeDelimitedFrom(input);
            }
            catch (FileNotFoundException e) {
                vsbuilder.setInvalidated(true).setVersion(-1);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            state = vsbuilder.build();
            this.xLocSetVSCache.put(fileId, state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setXLocSetVersionState(String fileId, OSD.XLocSetVersionState versionState) throws IOException {
        File fileDir = new File(this.generateAbsoluteFilePath(fileId));
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        File vsFile = new File(fileDir, XLOC_VERSION_STATE_FILENAME);
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(vsFile);
            versionState.writeDelimitedTo(output);
            this.xLocSetVSCache.put(fileId, versionState);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static final class ObjFileData {
        final long objNo;
        final long objVersion;
        final long checksum;

        public ObjFileData(long objNo, long objVersion, long checksum) {
            this.objNo = objNo;
            this.objVersion = objVersion;
            this.checksum = checksum;
        }
    }
}

