/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.xtreemfs.osd.storage.FileMetadata;

public class MetadataCache {
    private Map<String, FileMetadata> metadataMap = new ConcurrentSkipListMap<String, FileMetadata>();

    public FileMetadata getFileInfo(String fileId) {
        assert (fileId != null);
        return this.metadataMap.get(fileId);
    }

    public void setFileInfo(String fileId, FileMetadata info) {
        assert (info.getFilesize() != 0L || info.getLastObjectNumber() <= 0L);
        this.metadataMap.put(fileId, info);
    }

    public FileMetadata removeFileInfo(String fileId) {
        return this.metadataMap.remove(fileId);
    }
}

