/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.osd.InternalObjectData;

public class ObjectInformation {
    private ReusableBuffer data;
    private final ObjectStatus status;
    private final int stripeSize;
    private long lastLocalObjectNo;
    private long globalLastObjectNo;
    private boolean checksumInvalidOnOSD;

    public int getStripeSize() {
        return this.stripeSize;
    }

    public boolean isChecksumInvalidOnOSD() {
        return this.checksumInvalidOnOSD;
    }

    public void setChecksumInvalidOnOSD(boolean checksumInvalidOnOSD) {
        this.checksumInvalidOnOSD = checksumInvalidOnOSD;
    }

    public ObjectInformation(ObjectStatus status, ReusableBuffer data, int stripeSize) {
        this.data = data;
        this.status = status;
        this.stripeSize = stripeSize;
    }

    public InternalObjectData getObjectData(boolean isLastObject, int offset, int length) {
        assert (length >= 0);
        if (isLastObject) {
            switch (this.status) {
                case EXISTS: {
                    return new InternalObjectData(0, this.checksumInvalidOnOSD, 0, this.data);
                }
                case DOES_NOT_EXIST: {
                    return new InternalObjectData(0, this.checksumInvalidOnOSD, 0, null);
                }
                case PADDING_OBJECT: {
                    throw new RuntimeException("padding object must not be last object!");
                }
            }
        } else {
            switch (this.status) {
                case EXISTS: {
                    int paddingZeros = length - this.data.remaining();
                    assert (paddingZeros >= 0) : "offset: " + offset + " length: " + length + " remaining: " + this.data.remaining();
                    return new InternalObjectData(0, this.checksumInvalidOnOSD, paddingZeros, this.data);
                }
                case DOES_NOT_EXIST: 
                case PADDING_OBJECT: {
                    return new InternalObjectData(0, this.checksumInvalidOnOSD, length, this.data);
                }
            }
        }
        assert (false) : "should be unreachable";
        return null;
    }

    public ReusableBuffer getData() {
        return this.data;
    }

    public void setData(ReusableBuffer data) {
        this.data = data;
    }

    public ObjectStatus getStatus() {
        return this.status;
    }

    public long getLastLocalObjectNo() {
        return this.lastLocalObjectNo;
    }

    public void setLastLocalObjectNo(long lastLocalObjectNo) {
        this.lastLocalObjectNo = lastLocalObjectNo;
    }

    public long getGlobalLastObjectNo() {
        return this.globalLastObjectNo;
    }

    public void setGlobalLastObjectNo(long globalLastObjectNo) {
        this.globalLastObjectNo = globalLastObjectNo;
    }

    public static enum ObjectStatus {
        EXISTS,
        DOES_NOT_EXIST,
        PADDING_OBJECT;

    }
}

