/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.foundation.LRUCache;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.checksums.ChecksumAlgorithm;
import org.xtreemfs.foundation.checksums.ChecksumFactory;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.OSDConfig;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class RealSingleFileStorageLayout
extends StorageLayout {
    public static final int SL_TAG = 196609;
    private static final String DATA_SUFFIX = ".data";
    private static final String TEPOCH_SUFFIX = ".te";
    private static final int MDRECORD_SIZE = 16;
    private static final int DATA_HANDLE = 0;
    private final boolean checksumsEnabled;
    private ChecksumAlgorithm checksumAlgo;
    private final LRUCache<String, String> hashedPathCache;
    private static final int HASH_CUTOFF = 4;
    private final ByteBuffer mdata;
    private static final char[] hexTab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public RealSingleFileStorageLayout(OSDConfig config, MetadataCache cache) throws IOException {
        super(config, cache);
        this.checksumsEnabled = config.isUseChecksums();
        this.mdata = ByteBuffer.allocate(16);
        if (config.isUseChecksums()) {
            try {
                this.checksumAlgo = ChecksumFactory.getInstance().getAlgorithm(config.getChecksumProvider());
                if (this.checksumAlgo == null) {
                    throw new NoSuchAlgorithmException("algo is null");
                }
            }
            catch (NoSuchAlgorithmException e) {
                Logging.logMessage(3, Logging.Category.all, this, "could not instantiate checksum algorithm '%s'", config.getChecksumProvider());
                Logging.logMessage(3, Logging.Category.all, this, "OSD checksums will be switched off", new Object[0]);
            }
        }
        this.hashedPathCache = new LRUCache(2048);
        Logging.logMessage(3, this, "this storage layout is still under development and should not be used except for testing!", new Object[0]);
    }

    private long getOffsetForMetadata(int stripeSize, long row) {
        return (long)stripeSize * (row + 1L) + 16L * row;
    }

    private long getOffsetForData(int stripeSize, long row) {
        return (long)stripeSize * row + 16L * row;
    }

    @Override
    protected FileMetadata loadFileMetadata(String fileId, StripingPolicyImpl sp) throws IOException {
        File f;
        FileMetadata fi = new FileMetadata(sp);
        HashMap<Long, Long> tmp = new HashMap<Long, Long>();
        fi.initLatestObjectVersions(tmp);
        fi.initLargestObjectVersions(tmp);
        if (this.checksumsEnabled) {
            fi.initObjectChecksums(new HashMap<Long, Map<Long, Long>>());
        }
        if ((f = new File(this.getFilePath(fileId) + DATA_SUFFIX)).exists()) {
            this.openHandles(fi, fileId);
            RandomAccessFile ofile = fi.getHandles()[0];
            int stripeSize = sp.getStripeSizeForObject(0L);
            long fileSize = ofile.length();
            long numObjs = (long)Math.ceil((double)fileSize / (double)stripeSize);
            for (long i = 0L; i < numObjs; ++i) {
                long globalON = sp.getGloablObjectNumber(i);
                ofile.seek(this.getOffsetForMetadata(stripeSize, i));
                long chkSum = ofile.readLong();
                long version = ofile.readLong();
                if (version == 0L) continue;
                if (this.checksumsEnabled) {
                    fi.updateObjectChecksum(globalON, chkSum, version);
                }
                fi.updateObjectVersion(globalON, version);
            }
            fi.setLastObjectNumber(sp.getGloablObjectNumber(numObjs - 1L));
            fi.setFilesize((fi.getGlobalLastObjectNumber() - 1L) * (long)stripeSize + fileSize % (long)stripeSize);
            File tepoch = new File(this.getFilePath(fileId) + TEPOCH_SUFFIX);
            if (tepoch.exists()) {
                RandomAccessFile rf = new RandomAccessFile(tepoch, "r");
                fi.setTruncateEpoch(rf.readLong());
                rf.close();
            }
        } else {
            fi.setLastObjectNumber(-1L);
            fi.setFilesize(0L);
            fi.setTruncateEpoch(0L);
        }
        fi.setGlobalLastObjectNumber(-1L);
        return fi;
    }

    private void openHandles(FileMetadata md, String fileId) throws IOException {
        if (md.getHandles() == null) {
            String filename = this.getFilePath(fileId);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "open file: %s", filename);
            }
            RandomAccessFile ofile = new RandomAccessFile(filename + DATA_SUFFIX, "rw");
            RandomAccessFile[] handles = new RandomAccessFile[]{ofile};
            md.setHandles(handles);
        }
    }

    @Override
    public ObjectInformation readObject(String fileId, FileMetadata md, long objNo, int offset, int length, long version) throws IOException {
        this.openHandles(md, fileId);
        RandomAccessFile ofile = md.getHandles()[0];
        StripingPolicyImpl sp = md.getStripingPolicy();
        int stripeSize = sp.getStripeSizeForObject(objNo);
        long objFileOffset = sp.getRow(objNo) * (long)stripeSize + (long)offset;
        long fileSize = ofile.length();
        if (fileSize <= objFileOffset) {
            return new ObjectInformation(ObjectInformation.ObjectStatus.DOES_NOT_EXIST, null, stripeSize);
        }
        long objSize = fileSize - objFileOffset;
        if (objSize > (long)stripeSize) {
            objSize = stripeSize - offset;
        }
        if (length > 0 && objSize > (long)length) {
            objSize = length;
        }
        assert (objSize <= (long)stripeSize);
        ReusableBuffer obj = BufferPool.allocate((int)objSize);
        FileChannel c = ofile.getChannel();
        ofile.seek(objFileOffset);
        c.read(obj.getBuffer());
        obj.flip();
        ObjectInformation oInfo = new ObjectInformation(ObjectInformation.ObjectStatus.EXISTS, obj, stripeSize);
        if (this.checksumsEnabled) {
            ReusableBuffer data = BufferPool.allocate(stripeSize);
            ofile.seek(sp.getRow(objNo) * (long)stripeSize);
            c.read(data.getBuffer());
            this.checksumAlgo.reset();
            this.checksumAlgo.update(data.getBuffer());
            BufferPool.free(data);
            long newChecksum = this.checksumAlgo.getValue();
            oInfo.setChecksumInvalidOnOSD(newChecksum != md.getObjectChecksum(objNo, md.getLatestObjectVersion(objNo)));
        }
        return oInfo;
    }

    @Override
    public void writeObject(String fileId, FileMetadata md, ReusableBuffer data, long objNo, int offset, long newVersion, boolean sync, boolean cow) throws IOException {
        this.openHandles(md, fileId);
        RandomAccessFile ofile = md.getHandles()[0];
        StripingPolicyImpl sp = md.getStripingPolicy();
        int stripeSize = sp.getStripeSizeForObject(objNo);
        long row = sp.getRow(objNo);
        long mdOffset = this.getOffsetForMetadata(stripeSize, row);
        long objFileOffset = this.getOffsetForData(stripeSize, row) + (long)offset;
        FileChannel c = ofile.getChannel();
        ofile.seek(objFileOffset);
        data.position(0);
        boolean fullObjWrite = data.remaining() == stripeSize;
        c.write(data.getBuffer());
        long newChecksum = 0L;
        if (this.checksumsEnabled) {
            data.position(0);
            this.checksumAlgo.reset();
            if (!fullObjWrite) {
                long objOffset = sp.getRow(objNo) * (long)stripeSize;
                ReusableBuffer csumData = BufferPool.allocate(stripeSize);
                ofile.seek(objOffset);
                c.read(csumData.getBuffer());
                this.checksumAlgo.update(csumData.getBuffer());
                BufferPool.free(csumData);
            } else {
                this.checksumAlgo.update(data.getBuffer());
            }
            newChecksum = this.checksumAlgo.getValue();
            md.updateObjectChecksum(objNo, newVersion, newChecksum);
        }
        BufferPool.free(data);
        if (!fullObjWrite) {
            ofile.seek(mdOffset);
        }
        ofile.writeLong(newVersion);
        ofile.writeLong(newChecksum);
        md.updateObjectVersion(objNo, newVersion);
    }

    @Override
    public void deleteFile(String fileId, boolean deleteMetadata) throws IOException {
        File f = new File(this.getFilePath(fileId) + DATA_SUFFIX);
        f.delete();
        if (deleteMetadata) {
            // empty if block
        }
    }

    @Override
    public void deleteObject(String fileId, FileMetadata md, long objNo, long version) throws IOException {
        this.openHandles(md, fileId);
        RandomAccessFile ofile = md.getHandles()[0];
        StripingPolicyImpl sp = md.getStripingPolicy();
        int stripeSize = sp.getStripeSizeForObject(objNo);
        long row = sp.getRow(objNo);
        long objFileOffset = this.getOffsetForData(stripeSize, row);
        long fileSize = ofile.length();
        long lastObj = md.getLastObjectNumber();
        if (fileSize > 0L) {
            if (lastObj == objNo) {
                if (sp.getRow(objNo) == 0L) {
                    ofile.setLength(0L);
                } else {
                    long newLength = this.getOffsetForMetadata(stripeSize, row - 1L) + 16L;
                    ofile.setLength(newLength);
                }
            } else if (objNo < lastObj) {
                ReusableBuffer buf = BufferPool.allocate(stripeSize);
                while (buf.hasRemaining()) {
                    buf.put((byte)0);
                }
                buf.flip();
                FileChannel c = ofile.getChannel();
                c.position(objFileOffset);
                c.write(buf.getBuffer());
                ofile.writeLong(version);
                ofile.writeLong(0L);
            }
        }
    }

    @Override
    public void createPaddingObject(String fileId, FileMetadata md, long objNo, long version, int size) throws IOException {
        this.openHandles(md, fileId);
        RandomAccessFile ofile = md.getHandles()[0];
        StripingPolicyImpl sp = md.getStripingPolicy();
    }

    @Override
    public void setTruncateEpoch(String fileId, long newTruncateEpoch) throws IOException {
        RandomAccessFile rf = new RandomAccessFile(this.getFilePath(fileId) + TEPOCH_SUFFIX, "rw");
        rf.writeLong(newTruncateEpoch);
        rf.close();
    }

    @Override
    public boolean fileExists(String fileId) {
        File f = new File(this.getFilePath(fileId) + DATA_SUFFIX);
        return f.exists();
    }

    @Override
    public long getFileInfoLoadCount() {
        return 0L;
    }

    @Override
    public ObjectSet getObjectSet(String fileId, FileMetadata md) {
        ObjectSet objectSet = new ObjectSet(md.getLatestObjectVersions().size());
        for (Map.Entry<Long, Long> e : md.getLatestObjectVersions()) {
            objectSet.add(e.getKey());
        }
        return objectSet;
    }

    @Override
    public StorageLayout.FileList getFileList(StorageLayout.FileList l, int maxNumEntries) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getLayoutVersionTag() {
        return 196609;
    }

    @Override
    public boolean isCompatibleVersion(int layoutVersionTag) {
        return layoutVersionTag == 196609;
    }

    @Override
    public void truncateObject(String fileId, FileMetadata md, long objNo, int newLength, long newVersion, boolean cow) throws IOException {
        this.openHandles(md, fileId);
        RandomAccessFile ofile = md.getHandles()[0];
        StripingPolicyImpl sp = md.getStripingPolicy();
        int stripeSize = sp.getStripeSizeForObject(objNo);
        long objFileOffset = sp.getRow(objNo) * (long)stripeSize;
        long fileSize = ofile.length();
        long lastObj = sp.getObjectNoForOffset(fileSize);
        if (lastObj == objNo) {
            ofile.setLength(objFileOffset + (long)newLength);
            long newChecksum = 0L;
            if (this.checksumsEnabled) {
                this.checksumAlgo.reset();
                long objOffset = sp.getRow(objNo) * (long)stripeSize;
                ReusableBuffer csumData = BufferPool.allocate(stripeSize);
                ofile.seek(objOffset);
                ofile.getChannel().read(csumData.getBuffer());
                this.checksumAlgo.update(csumData.getBuffer());
                BufferPool.free(csumData);
                newChecksum = this.checksumAlgo.getValue();
                md.updateObjectChecksum(objNo, newVersion, newChecksum);
            }
        }
    }

    private String getFilePath(String fileId) {
        String path = (String)this.hashedPathCache.get(fileId);
        if (path == null) {
            StringBuilder hashPath = new StringBuilder(this.storageDir.length() + fileId.length() + 2 + 4);
            hashPath.append(this.storageDir);
            int hash = fileId.hashCode();
            hashPath.append(OutputUtils.trHex[hash & 0xF]);
            hashPath.append(OutputUtils.trHex[hash >> 4 & 0xF]);
            hashPath.append("/");
            hashPath.append(OutputUtils.trHex[hash >> 8 & 0xF]);
            hashPath.append(OutputUtils.trHex[hash >> 12 & 0xF]);
            hashPath.append("/");
            String dirs = hashPath.toString();
            File f = new File(dirs);
            f.mkdirs();
            hashPath.append(fileId);
            path = hashPath.toString();
            this.hashedPathCache.put(fileId, path);
        }
        return path;
    }

    @Override
    public void updateCurrentObjVersion(String fileId, long objNo, long newVersion) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCurrentVersionSize(String fileId, long newLastObject) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<String> getFileIDList() {
        ArrayList<String> fileList = new ArrayList<String>();
        Stack<String> directories = new Stack<String>();
        directories.push(this.storageDir);
        while (!directories.empty()) {
            File currentFile = new File((String)directories.pop());
            for (File f : currentFile.listFiles()) {
                String fName;
                if (f != null && f.isDirectory()) {
                    directories.push(f.getAbsolutePath());
                    continue;
                }
                if (f == null || !f.isFile() || f.getName().endsWith(".ser") || !f.getName().contains(":") || fileList.indexOf(fName = f.getName().replace(DATA_SUFFIX, "").replace(TEPOCH_SUFFIX, "")) == -1) continue;
                fileList.add(fName);
            }
        }
        return fileList;
    }

    @Override
    public int getMasterEpoch(String fileId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMasterEpoch(String fileId, int masterEpoch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OSD.TruncateLog getTruncateLog(String fileId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTruncateLog(String fileId, OSD.TruncateLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OSD.XLocSetVersionState getXLocSetVersionState(String fileId) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setXLocSetVersionState(String fileId, OSD.XLocSetVersionState versionState) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

