/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.osd.InternalObjectData;
import org.xtreemfs.osd.OSDConfig;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public abstract class StorageLayout {
    public static final int FULL_OBJECT_LENGTH = -1;
    public static final int LATEST_VERSION = -1;
    public static final String VERSION_FILENAME = ".version";
    public static final boolean WIN = System.getProperty("os.name").toLowerCase().contains("win");
    protected final String storageDir;
    protected final MetadataCache cache;

    protected StorageLayout(OSDConfig config, MetadataCache cache) throws IOException {
        this.cache = cache;
        String tmp = config.getObjDir();
        if (!tmp.endsWith("/")) {
            tmp = tmp + "/";
        }
        this.storageDir = tmp;
        File stdir = new File(this.storageDir);
        stdir.mkdirs();
        File versionMetaFile = new File(this.storageDir, VERSION_FILENAME);
        if (versionMetaFile.exists()) {
            FileReader in = new FileReader(versionMetaFile);
            char[] text = new char[(int)versionMetaFile.length()];
            in.read(text);
            in.close();
            int versionOnDisk = Integer.valueOf(new String(text));
            if (!this.isCompatibleVersion(versionOnDisk)) {
                throw new IOException("the OSD storage layout used to create the data on disk (" + versionOnDisk + ") is not compatible with the storage layout loaded: " + this.getClass().getSimpleName());
            }
        }
        File tmpFile = new File(versionMetaFile + ".tmp");
        FileWriter out = new FileWriter(tmpFile);
        out.write(Integer.toString(this.getLayoutVersionTag()));
        out.close();
        tmpFile.renameTo(versionMetaFile);
    }

    public FileMetadata getFileMetadata(StripingPolicyImpl sp, String fileId) throws IOException {
        FileMetadata fi = this.cache.getFileInfo(fileId);
        if (fi == null) {
            fi = this.loadFileMetadata(fileId, sp);
            this.cache.setFileInfo(fileId, fi);
        }
        return fi;
    }

    public FileMetadata getFileMetadataNoCaching(StripingPolicyImpl sp, String fileId) throws IOException {
        FileMetadata fi = this.cache.getFileInfo(fileId);
        if (fi == null) {
            fi = this.loadFileMetadata(fileId, sp);
        }
        return fi;
    }

    protected abstract FileMetadata loadFileMetadata(String var1, StripingPolicyImpl var2) throws IOException;

    public void closeFile(FileMetadata metadata) {
    }

    public abstract ObjectInformation readObject(String var1, FileMetadata var2, long var3, int var5, int var6, long var7) throws IOException;

    public abstract void writeObject(String var1, FileMetadata var2, ReusableBuffer var3, long var4, int var6, long var7, boolean var9, boolean var10) throws IOException;

    public abstract void truncateObject(String var1, FileMetadata var2, long var3, int var5, long var6, boolean var8) throws IOException;

    public abstract void deleteFile(String var1, boolean var2) throws IOException;

    public abstract void deleteObject(String var1, FileMetadata var2, long var3, long var5) throws IOException;

    public abstract void createPaddingObject(String var1, FileMetadata var2, long var3, long var5, int var7) throws IOException;

    public abstract void setTruncateEpoch(String var1, long var2) throws IOException;

    public abstract boolean fileExists(String var1);

    protected ReusableBuffer unwrapObjectData(String fileId, FileMetadata md, long objNo, long oldVersion) throws IOException {
        ReusableBuffer data;
        int stripeSize = md.getStripingPolicy().getStripeSizeForObject(objNo);
        boolean isLastObj = md.getLastObjectNumber() == objNo || objNo == 0L && md.getLastObjectNumber() == -1L;
        ObjectInformation obj = this.readObject(fileId, md, objNo, 0, -1, oldVersion);
        InternalObjectData oldObject = obj.getObjectData(isLastObj, 0, stripeSize);
        if (obj.getData() == null) {
            if (oldObject.getZero_padding() > 0) {
                data = BufferPool.allocate(oldObject.getZero_padding());
                for (int i = 0; i < oldObject.getZero_padding(); ++i) {
                    data.put((byte)0);
                }
                data.position(0);
            } else {
                data = BufferPool.allocate(0);
            }
        } else if (oldObject.getZero_padding() > 0) {
            data = BufferPool.allocate(obj.getData().capacity() + oldObject.getZero_padding());
            data.put(obj.getData());
            for (int i = 0; i < oldObject.getZero_padding(); ++i) {
                data.put((byte)0);
            }
        } else {
            data = obj.getData();
        }
        return data;
    }

    protected ReusableBuffer cow(String fileId, FileMetadata md, long objNo, ReusableBuffer data, int offset, long oldVersion) throws IOException {
        ReusableBuffer writeData = null;
        int stripeSize = md.getStripingPolicy().getStripeSizeForObject(objNo);
        ObjectInformation obj = this.readObject(fileId, md, objNo, 0, -1, oldVersion);
        boolean isLastObj = md.getLastObjectNumber() == objNo || objNo == 0L && md.getLastObjectNumber() == -1L;
        InternalObjectData oldObject = obj.getObjectData(isLastObj, 0, stripeSize);
        if (obj.getData() == null) {
            if (oldObject.getZero_padding() > 0) {
                writeData = BufferPool.allocate(stripeSize);
                for (int i = 0; i < stripeSize; ++i) {
                    writeData.put((byte)0);
                }
                writeData.position(offset);
                writeData.put(data);
                writeData.position(0);
                BufferPool.free(data);
            } else if (offset > 0) {
                writeData = BufferPool.allocate(offset + data.capacity());
                for (int i = 0; i < offset; ++i) {
                    writeData.put((byte)0);
                }
                writeData.put(data);
                writeData.position(0);
                BufferPool.free(data);
            } else {
                writeData = data;
            }
        } else if (obj.getData().capacity() >= offset + data.capacity()) {
            writeData = obj.getData();
            writeData.position(offset);
            writeData.put(data);
            BufferPool.free(data);
        } else {
            writeData = BufferPool.allocate(offset + data.capacity());
            writeData.put(obj.getData());
            BufferPool.free(obj.getData());
            writeData.position(offset);
            writeData.put(data);
            BufferPool.free(data);
        }
        return writeData;
    }

    public abstract void updateCurrentObjVersion(String var1, long var2, long var4) throws IOException;

    public abstract void updateCurrentVersionSize(String var1, long var2) throws IOException;

    public abstract long getFileInfoLoadCount();

    public abstract ObjectSet getObjectSet(String var1, FileMetadata var2);

    public abstract FileList getFileList(FileList var1, int var2);

    public abstract int getLayoutVersionTag();

    public abstract boolean isCompatibleVersion(int var1);

    public abstract int getMasterEpoch(String var1) throws IOException;

    public abstract void setMasterEpoch(String var1, int var2) throws IOException;

    public abstract OSD.TruncateLog getTruncateLog(String var1) throws IOException;

    public abstract void setTruncateLog(String var1, OSD.TruncateLog var2) throws IOException;

    public abstract ArrayList<String> getFileIDList();

    public abstract OSD.XLocSetVersionState getXLocSetVersionState(String var1) throws IOException;

    public abstract void setXLocSetVersionState(String var1, OSD.XLocSetVersionState var2) throws IOException;

    public static final class FileData {
        final long size;
        final int objectSize;
        final boolean metaDataOnly;

        FileData(long size, int objectSize) {
            this.size = size;
            this.objectSize = objectSize;
            this.metaDataOnly = false;
        }

        FileData(boolean metaDataOnly) {
            this.size = 0L;
            this.objectSize = 0;
            this.metaDataOnly = metaDataOnly;
        }
    }

    public static final class FileList {
        final Stack<String> status;
        final Map<String, FileData> files;
        boolean hasMore;

        public FileList(Stack<String> status, Map<String, FileData> files) {
            this.status = status;
            this.files = files;
        }
    }
}

