/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.Replica;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.replication.ObjectSet;
import org.xtreemfs.osd.stages.Stage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.storage.CowPolicy;
import org.xtreemfs.osd.storage.FileMetadata;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.storage.ObjectInformation;
import org.xtreemfs.osd.storage.StorageLayout;
import org.xtreemfs.osd.storage.VersionTable;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class StorageThread
extends Stage {
    public static final int STAGEOP_READ_OBJECT = 1;
    public static final int STAGEOP_WRITE_OBJECT = 2;
    public static final int STAGEOP_TRUNCATE = 3;
    public static final int STAGEOP_FLUSH_CACHES = 4;
    public static final int STAGEOP_GMAX_RECEIVED = 5;
    public static final int STAGEOP_GET_GMAX = 6;
    public static final int STAGEOP_GET_FILE_SIZE = 7;
    public static final int STAGEOP_GET_OBJECT_SET = 8;
    public static final int STAGEOP_INSERT_PADDING_OBJECT = 9;
    public static final int STAGEOP_GET_MAX_OBJNO = 10;
    public static final int STAGEOP_CREATE_FILE_VERSION = 11;
    public static final int STAGEOP_GET_REPLICA_STATE = 12;
    public static final int STAGEOP_GET_FILEID_LIST = 13;
    public static final int STAGEOP_DELETE_OBJECTS = 14;
    private MetadataCache cache;
    private StorageLayout layout;
    private OSDRequestDispatcher master;
    private final boolean checksumsEnabled;

    public StorageThread(int id, OSDRequestDispatcher dispatcher, MetadataCache cache, StorageLayout layout, int maxQueueLength) {
        super("OSD StThr " + id, maxQueueLength);
        this.cache = cache;
        this.layout = layout;
        this.master = dispatcher;
        this.checksumsEnabled = this.master.getConfig().isUseChecksums();
    }

    @Override
    protected void processMethod(Stage.StageRequest method) {
        try {
            switch (method.getStageMethod()) {
                case 1: {
                    this.processRead(method);
                    break;
                }
                case 2: {
                    this.processWrite(method);
                    break;
                }
                case 3: {
                    this.processTruncate(method);
                    break;
                }
                case 4: {
                    this.processFlushCaches(method);
                    break;
                }
                case 5: {
                    this.processGmax(method);
                    break;
                }
                case 6: {
                    this.processGetGmax(method);
                    break;
                }
                case 7: {
                    this.processGetFileSize(method);
                    break;
                }
                case 8: {
                    this.processGetObjectSet(method);
                    break;
                }
                case 9: {
                    this.processInsertPaddingObject(method);
                    break;
                }
                case 10: {
                    this.processGetMaxObjNo(method);
                    break;
                }
                case 11: {
                    this.processCreateFileVersion(method);
                    break;
                }
                case 12: {
                    this.processGetReplicaState(method);
                    break;
                }
                case 13: {
                    this.processGetFileIDList(method);
                    break;
                }
                case 14: {
                    this.processDeleteObjects(method);
                }
            }
        }
        catch (Exception ex) {
            method.sendInternalServerError(ex);
            Logging.logError(3, this, ex);
        }
    }

    private void processGetMaxObjNo(Stage.StageRequest rq) {
        StorageStage.InternalGetMaxObjectNoCallback cback = (StorageStage.InternalGetMaxObjectNoCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[1];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            long currentMax = -1L;
            int i = 0;
            while ((long)i < fi.getLastObjectNumber()) {
                long objVer = fi.getLargestObjectVersion(i);
                if (objVer > currentMax) {
                    currentMax = objVer;
                }
                ++i;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "getmaxobjno for fileId %s: %d", fileId, currentMax);
            }
            cback.maxObjectNoCompleted(currentMax, fi.getFilesize(), fi.getTruncateEpoch(), null);
        }
        catch (Exception ex) {
            cback.maxObjectNoCompleted(0L, 0L, 0L, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processGmax(Stage.StageRequest rq) {
        try {
            String fileId = (String)rq.getArgs()[0];
            long epoch = (Long)rq.getArgs()[1];
            long lastObject = (Long)rq.getArgs()[2];
            FileMetadata fi = this.cache.getFileInfo(fileId);
            if (fi == null) {
                return;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "received new GMAX: %d/%d for %s", lastObject, epoch, fileId);
            }
            if (epoch == fi.getTruncateEpoch() && fi.getLastObjectNumber() < lastObject || epoch > fi.getTruncateEpoch()) {
                fi.setGlobalLastObjectNumber(lastObject);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.proc, this, "received GMAX is valid; for %s, current (fs, epoch) = (%d, %d)", fileId, fi.getFilesize(), fi.getTruncateEpoch());
                }
            } else if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "received GMAX is outdated; for %s, current (fs, epoch) = (%d, %d)", fileId, fi.getFilesize(), fi.getTruncateEpoch());
            }
        }
        catch (Exception ex) {
            Logging.logError(7, this, ex);
            return;
        }
    }

    private void processFlushCaches(Stage.StageRequest rq) {
        StorageStage.CachesFlushedCallback cback = (StorageStage.CachesFlushedCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            FileMetadata md = this.cache.removeFileInfo(fileId);
            if (md != null) {
                this.layout.closeFile(null);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "removed file info from cache for file %s", fileId);
            }
            cback.cachesFlushed(null, md);
        }
        catch (Exception ex) {
            rq.sendInternalServerError(ex);
            return;
        }
    }

    private void processGetGmax(Stage.StageRequest rq) {
        StorageStage.InternalGetGmaxCallback cback = (StorageStage.InternalGetGmaxCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[1];
            long snapTimestamp = (Long)rq.getArgs()[2];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "GET GMAX: %s", fileId);
            }
            long fileSize = -1L;
            long lastObj = -1L;
            if (snapTimestamp > 0L) {
                VersionTable.Version v = fi.getVersionTable().getLatestVersionBefore(snapTimestamp);
                lastObj = v.getObjCount() - 1;
                fileSize = v.getFileSize();
            } else {
                lastObj = fi.getLastObjectNumber();
                fileSize = fi.getFilesize();
            }
            OSD.InternalGmax gmax = OSD.InternalGmax.newBuilder().setEpoch(fi.getTruncateEpoch()).setFileSize(fileSize).setLastObjectId(lastObj).build();
            cback.gmaxComplete(gmax, null);
        }
        catch (IOException ex) {
            cback.gmaxComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processGetReplicaState(Stage.StageRequest rq) {
        StorageStage.InternalGetReplicaStateCallback cback = (StorageStage.InternalGetReplicaStateCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[1];
            long remoteMaxObjVer = (Long)rq.getArgs()[2];
            assert (remoteMaxObjVer == 0L) : "Received a request with remoteMaxObjVer != 0. This probably means that you run OSDs with different versions. Please update all OSDs to the same version.";
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "GET replica state: %s, remote max: %d", fileId, remoteMaxObjVer);
            }
            OSD.ReplicaStatus.Builder result = OSD.ReplicaStatus.newBuilder();
            result.setFileSize(fi.getFilesize());
            result.setTruncateEpoch(fi.getTruncateEpoch());
            long localMaxObjVer = 0L;
            for (Map.Entry<Long, Long> e : fi.getLatestObjectVersions()) {
                if (e.getValue() <= remoteMaxObjVer) continue;
                result.addObjectVersions(OSD.ObjectVersion.newBuilder().setObjectNumber(e.getKey()).setObjectVersion(e.getValue()));
                if (e.getValue() <= localMaxObjVer) continue;
                localMaxObjVer = e.getValue();
            }
            result.setMaxObjVersion(localMaxObjVer);
            result.setPrimaryEpoch(0);
            result.setTruncateLog(this.layout.getTruncateLog(fileId));
            cback.getReplicaStateComplete(result.build(), null);
        }
        catch (IOException ex) {
            cback.getReplicaStateComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processRead(Stage.StageRequest rq) {
        StorageStage.ReadObjectCallback cback = (StorageStage.ReadObjectCallback)rq.getCallback();
        try {
            long objVer;
            String fileId = (String)rq.getArgs()[0];
            long objNo = (Long)rq.getArgs()[1];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[2];
            int offset = (Integer)rq.getArgs()[3];
            int length = (Integer)rq.getArgs()[4];
            long versionTimestamp = (Long)rq.getArgs()[5];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "READ: %s-%d offset=%d, length=%d", fileId, objNo, offset, length);
            }
            long l = objVer = versionTimestamp != 0L ? (long)fi.getVersionTable().getLatestVersionBefore(versionTimestamp).getObjVersion(objNo) : fi.getLatestObjectVersion(objNo);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "getting objVer %d", objVer);
            }
            long objChksm = fi.getObjectChecksum(objNo, objVer);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "checksum is %d", objChksm);
            }
            ObjectInformation obj = this.layout.readObject(fileId, fi, objNo, offset, length, objVer);
            if (versionTimestamp != 0L) {
                int lastObj = fi.getVersionTable().getLatestVersionBefore(versionTimestamp).getObjCount() - 1;
                obj.setLastLocalObjectNo(lastObj);
                obj.setGlobalLastObjectNo(lastObj);
            } else {
                obj.setLastLocalObjectNo(fi.getLastObjectNumber());
                obj.setGlobalLastObjectNo(fi.getGlobalLastObjectNumber());
            }
            cback.readComplete(obj, null);
        }
        catch (IOException ex) {
            cback.readComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processGetFileSize(Stage.StageRequest rq) {
        StorageStage.GetFileSizeCallback cback = (StorageStage.GetFileSizeCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[1];
            long snapTimestamp = (Long)rq.getArgs()[2];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            if (snapTimestamp > 0L) {
                VersionTable.Version v = fi.getVersionTable().getLatestVersionBefore(snapTimestamp);
                cback.getFileSizeComplete(v.getFileSize(), null);
            } else {
                cback.getFileSizeComplete(fi.getFilesize(), null);
            }
        }
        catch (IOException ex) {
            cback.getFileSizeComplete(-1L, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processInsertPaddingObject(Stage.StageRequest rq) {
        StorageStage.WriteObjectCallback cback = (StorageStage.WriteObjectCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            long objNo = (Long)rq.getArgs()[1];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[2];
            int size = (Integer)rq.getArgs()[3];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            long version = fi.getLatestObjectVersion(objNo) + 1L;
            this.layout.createPaddingObject(fileId, fi, objNo, version, size);
            GlobalTypes.OSDWriteResponse response = GlobalTypes.OSDWriteResponse.newBuilder().build();
            cback.writeComplete(response, null);
        }
        catch (IOException ex) {
            Logging.logMessage(7, Logging.Category.storage, this, "Failed to create a padded object due to the following IOException:", new Object[0]);
            Logging.logError(3, this, ex);
            cback.writeComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processWrite(Stage.StageRequest rq) {
        StorageStage.WriteObjectCallback cback = (StorageStage.WriteObjectCallback)rq.getCallback();
        try {
            long newVersion;
            int dataCapacity;
            String fileId = (String)rq.getArgs()[0];
            long objNo = (Long)rq.getArgs()[1];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[2];
            int offset = (Integer)rq.getArgs()[3];
            ReusableBuffer data = (ReusableBuffer)rq.getArgs()[4];
            CowPolicy cow = (CowPolicy)rq.getArgs()[5];
            XLocations xloc = (XLocations)rq.getArgs()[6];
            boolean gMaxOff = (Boolean)rq.getArgs()[7];
            boolean syncWrite = (Boolean)rq.getArgs()[8];
            Long newVersionArg = (Long)rq.getArgs()[9];
            int dataLength = data.remaining();
            int stripeSize = sp.getStripeSizeForObject(objNo);
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "WRITE: %s-%d. last objNo=%d dataSize=%d at offset=%d", fileId, objNo, fi.getLastObjectNumber(), dataLength, offset);
            }
            if (offset + (dataCapacity = data.capacity()) > stripeSize) {
                BufferPool.free(data);
                cback.writeComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EINVAL, "offset+data.length must be <= stripe size (offset=" + offset + " data.length=" + dataCapacity + " stripe size=" + stripeSize + ")"));
                return;
            }
            cow.initCowFlagsIfRequired(fi.getLastObjectNumber() + 1L);
            long largestV = fi.getLargestObjectVersion(objNo);
            boolean isCow = cow.isCOW((int)objNo);
            long l = newVersion = isCow || this.checksumsEnabled ? largestV + 1L : Math.max(1L, largestV);
            if (newVersionArg != null) {
                newVersion = newVersionArg;
            }
            assert (data != null);
            if (objNo > fi.getLastObjectNumber()) {
                fi.setLastObjectNumber(objNo);
            }
            this.layout.writeObject(fileId, fi, data, objNo, offset, newVersion, syncWrite, isCow);
            if (cow.cowEnabled() && (isCow || largestV == 0L)) {
                this.layout.updateCurrentObjVersion(fileId, objNo, newVersion);
            }
            if (isCow) {
                cow.objectChanged((int)objNo);
            }
            GlobalTypes.OSDWriteResponse.Builder response = GlobalTypes.OSDWriteResponse.newBuilder();
            if (objNo >= fi.getLastObjectNumber() && !gMaxOff) {
                long newObjSize = dataLength + offset;
                long newFS = 0L;
                newFS = objNo > 0L ? sp.getObjectEndOffset(objNo - 1L) + 1L + newObjSize : newObjSize;
                if (newFS < fi.getFilesize()) {
                    newFS = fi.getFilesize();
                }
                if (newFS > fi.getFilesize() && objNo >= fi.getLastObjectNumber() && objNo >= fi.getGlobalLastObjectNumber()) {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.proc, this, "new filesize: %d", newFS);
                    }
                    response.setSizeInBytes(newFS);
                    response.setTruncateEpoch((int)fi.getTruncateEpoch());
                } else if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.proc, this, "no new filesize: %d/%d, %d/%d", newFS, fi.getFilesize(), fi.getLastObjectNumber(), objNo);
                }
                fi.setFilesize(newFS);
                if (objNo > fi.getLastObjectNumber() && objNo > fi.getGlobalLastObjectNumber()) {
                    List<ServiceUUID> osds = xloc.getLocalReplica().getOSDs();
                    ServiceUUID localUUID = this.master.getConfig().getUUID();
                    if (osds.size() > 1) {
                        RPC.RPCHeader.RequestHeader rqHdr = RPC.RPCHeader.RequestHeader.newBuilder().setAuthData(RPCAuthentication.authNone).setUserCreds(RPCAuthentication.userService).setInterfaceId(30001).setProcId(20).build();
                        RPC.RPCHeader header = RPC.RPCHeader.newBuilder().setCallId(0).setMessageType(RPC.MessageType.RPC_REQUEST).setRequestHeader(rqHdr).build();
                        OSD.xtreemfs_broadcast_gmaxRequest gmaxRq = OSD.xtreemfs_broadcast_gmaxRequest.newBuilder().setFileId(fileId).setTruncateEpoch(fi.getTruncateEpoch()).setLastObject(objNo).build();
                        for (ServiceUUID osd : osds) {
                            if (osd.equals(localUUID)) continue;
                            this.master.sendUDPMessage(header, gmaxRq, osd.getAddress());
                        }
                    }
                }
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "new last object=%d gmax=%d", fi.getLastObjectNumber(), fi.getGlobalLastObjectNumber());
            }
            cback.writeComplete(response.build(), null);
        }
        catch (IOException ex) {
            Logging.logMessage(7, Logging.Category.storage, this, "Failed to process write() request due to the following IOException:", new Object[0]);
            Logging.logError(3, this, ex);
            cback.writeComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processDeleteObjects(Stage.StageRequest rq) throws IOException {
        StorageStage.DeleteObjectsCallback cback = (StorageStage.DeleteObjectsCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[1];
            long epochNumber = (Long)rq.getArgs()[2];
            Map objectsToBeDeleted = (Map)rq.getArgs()[3];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            for (Map.Entry obj : objectsToBeDeleted.entrySet()) {
                this.layout.deleteObject(fileId, fi, (Long)obj.getKey(), (Long)obj.getValue());
            }
            this.layout.setTruncateEpoch(fileId, epochNumber);
            this.cache.removeFileInfo(fileId);
            cback.deleteObjectsComplete(null);
        }
        catch (Exception ex) {
            cback.deleteObjectsComplete(ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processTruncate(Stage.StageRequest rq) throws IOException {
        StorageStage.TruncateCallback cback = (StorageStage.TruncateCallback)rq.getCallback();
        try {
            String fileId = (String)rq.getArgs()[0];
            long newFileSize = (Long)rq.getArgs()[1];
            StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[2];
            Replica currentReplica = (Replica)rq.getArgs()[3];
            long epochNumber = (Long)rq.getArgs()[4];
            CowPolicy cow = (CowPolicy)rq.getArgs()[5];
            Long newObjVer = (Long)rq.getArgs()[6];
            Boolean createTLogEntry = (Boolean)rq.getArgs()[7];
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            if (fi.getTruncateEpoch() >= epochNumber) {
                cback.truncateComplete(GlobalTypes.OSDWriteResponse.newBuilder().setSizeInBytes(fi.getFilesize()).setTruncateEpoch((int)fi.getTruncateEpoch()).build(), null);
                return;
            }
            cow.initCowFlagsIfRequired(fi.getLastObjectNumber() + 1L);
            int relativeOSDNumber = currentReplica.getOSDs().indexOf(this.master.getConfig().getUUID());
            long newLastObject = -1L;
            long newGlobalLastObject = -1L;
            if (newFileSize == 0L) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.proc, this, "truncate to 0", new Object[0]);
                }
                if (cow.cowEnabled()) {
                    for (Map.Entry<Long, Long> entry : fi.getLatestObjectVersions()) {
                        long objNo = entry.getKey();
                        long objVer = entry.getValue();
                        if (fi.getVersionTable().isContained(objNo, objVer)) continue;
                        this.layout.deleteObject(fileId, fi, objNo, objVer);
                    }
                } else {
                    this.layout.deleteFile(fileId, false);
                }
                fi.clearLatestObjectVersions();
            } else if (fi.getFilesize() > newFileSize) {
                newLastObject = this.truncateShrink(fileId, newFileSize, epochNumber, sp, fi, relativeOSDNumber, cow, newObjVer);
                newGlobalLastObject = sp.getObjectNoForOffset(newFileSize - 1L);
            } else if (fi.getFilesize() < newFileSize) {
                newLastObject = this.truncateExtend(fileId, newFileSize, epochNumber, sp, fi, relativeOSDNumber, cow, newObjVer);
                newGlobalLastObject = sp.getObjectNoForOffset(newFileSize - 1L);
            } else if (fi.getFilesize() == newFileSize) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.proc, this, "truncate to local size: %d", newFileSize);
                }
                newLastObject = fi.getLastObjectNumber();
                newGlobalLastObject = fi.getGlobalLastObjectNumber();
            }
            fi.setFilesize(newFileSize);
            fi.setLastObjectNumber(newLastObject);
            fi.setTruncateEpoch(epochNumber);
            fi.setGlobalLastObjectNumber(newGlobalLastObject);
            this.layout.setTruncateEpoch(fileId, epochNumber);
            if (cow.cowEnabled()) {
                this.layout.updateCurrentVersionSize(fileId, newLastObject);
            }
            if (createTLogEntry.booleanValue()) {
                OSD.TruncateLog log = this.layout.getTruncateLog(fileId);
                log = log.toBuilder().addRecords(OSD.TruncateRecord.newBuilder().setVersion(newObjVer).setLastObjectNumber(newLastObject)).build();
                this.layout.setTruncateLog(fileId, log);
            }
            GlobalTypes.OSDWriteResponse response = GlobalTypes.OSDWriteResponse.newBuilder().setSizeInBytes(newFileSize).setTruncateEpoch((int)epochNumber).build();
            cback.truncateComplete(response, null);
        }
        catch (Exception ex) {
            cback.truncateComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processGetObjectSet(Stage.StageRequest rq) {
        StorageStage.GetObjectListCallback cback = (StorageStage.GetObjectListCallback)rq.getCallback();
        String fileId = (String)rq.getArgs()[0];
        StripingPolicyImpl sp = (StripingPolicyImpl)rq.getArgs()[1];
        try {
            FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
            ObjectSet objectSet = this.layout.getObjectSet(fileId, fi);
            cback.getObjectSetComplete(objectSet, null);
        }
        catch (Exception ex) {
            cback.getObjectSetComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processCreateFileVersion(Stage.StageRequest rq) {
        StorageStage.CreateFileVersionCallback cback = (StorageStage.CreateFileVersionCallback)rq.getCallback();
        String fileId = (String)rq.getArgs()[0];
        FileMetadata fi = (FileMetadata)rq.getArgs()[1];
        try {
            if (fi == null) {
                fi = this.layout.getFileMetadataNoCaching(null, fileId);
            }
            Set<Map.Entry<Long, Long>> objVersions = fi.getLatestObjectVersions();
            long fileSize = fi.getFilesize();
            long maxKey = -1L;
            for (Map.Entry<Long, Long> ver : objVersions) {
                if (ver.getKey() <= maxKey) continue;
                maxKey = ver.getKey();
            }
            assert (maxKey < Integer.MAX_VALUE);
            int[] versions = new int[(int)maxKey + 1];
            for (Map.Entry<Long, Long> ver : objVersions) {
                versions[ver.getKey().intValue()] = ver.getValue().intValue();
            }
            fi.getVersionTable().addVersion(TimeSync.getGlobalTime(), versions, fileSize);
            try {
                fi.getVersionTable().save();
            }
            catch (IOException e) {
                Logging.logMessage(7, Logging.Category.proc, this, OutputUtils.stackTraceToString(e), new Object[0]);
            }
            cback.createFileVersionComplete(fileSize, null);
        }
        catch (Exception ex) {
            Logging.logError(3, this, ex);
            cback.createFileVersionComplete(0L, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private void processGetFileIDList(Stage.StageRequest rq) {
        StorageStage.GetFileIDListCallback cback = (StorageStage.GetFileIDListCallback)rq.getCallback();
        ArrayList<String> fileIDList = null;
        try {
            if (this.layout != null) {
                fileIDList = this.layout.getFileIDList();
            }
            cback.createGetFileIDListComplete(fileIDList, null);
        }
        catch (Exception ex) {
            Logging.logError(3, this, ex);
            cback.createGetFileIDListComplete(null, ErrorUtils.getErrorResponse(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_EIO, ex.toString()));
        }
    }

    private long truncateShrink(String fileId, long fileSize, long epoch, StripingPolicyImpl sp, FileMetadata fi, int relOsdId, CowPolicy cow, Long newObjVer) throws IOException {
        long rowObj;
        long r;
        long lastRow;
        long oldRow;
        long newLastObject = sp.getObjectNoForOffset(fileSize - 1L);
        long oldLastObject = fi.getLastObjectNumber();
        assert (newLastObject <= oldLastObject) : "new= " + newLastObject + " old=" + oldLastObject;
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.proc, this, "truncate shrink to: %d old last: %d   new last: %d", fileSize, fi.getLastObjectNumber(), newLastObject);
        }
        if (cow.cowEnabled()) {
            oldRow = sp.getRow(oldLastObject);
            lastRow = sp.getRow(newLastObject);
            for (r = oldRow; r >= lastRow; --r) {
                rowObj = r * (long)sp.getWidth() + (long)relOsdId;
                if (rowObj == newLastObject) {
                    int newObjSize = (int)(fileSize - sp.getObjectStartOffset(newLastObject));
                    this.truncateObject(fileId, newLastObject, sp, newObjSize, relOsdId, cow, newObjVer);
                    continue;
                }
                if (rowObj <= newLastObject) continue;
                long v = fi.getLatestObjectVersion(rowObj);
                if (!fi.getVersionTable().isContained(rowObj, v)) {
                    this.layout.deleteObject(fileId, fi, rowObj, v);
                }
                fi.discardObject(rowObj, v);
            }
        } else {
            oldRow = sp.getRow(oldLastObject);
            lastRow = sp.getRow(newLastObject);
            for (r = oldRow; r >= lastRow; --r) {
                rowObj = r * (long)sp.getWidth() + (long)relOsdId;
                if (rowObj == newLastObject) {
                    int newObjSize = (int)(fileSize - sp.getObjectStartOffset(newLastObject));
                    this.truncateObject(fileId, newLastObject, sp, newObjSize, relOsdId, cow, newObjVer);
                    continue;
                }
                if (rowObj <= newLastObject) continue;
                long v = fi.getLatestObjectVersion(rowObj);
                this.layout.deleteObject(fileId, fi, rowObj, v);
                fi.discardObject(rowObj, v);
            }
        }
        for (long obj = newLastObject - 1L; obj > newLastObject - (long)sp.getWidth(); --obj) {
            long v;
            if (obj <= 0L || !sp.isLocalObject(obj, relOsdId) || (v = fi.getLatestObjectVersion(obj)) != 0L) continue;
            this.createPaddingObject(fileId, obj, sp, fi.getLargestObjectVersion(obj) + 1L, sp.getStripeSizeForObject(obj), fi);
        }
        return newLastObject;
    }

    private long truncateExtend(String fileId, long fileSize, long epoch, StripingPolicyImpl sp, FileMetadata fi, int relOsdId, CowPolicy cow, Long newObjVer) throws IOException {
        long newLastObject = sp.getObjectNoForOffset(fileSize - 1L);
        long oldLastObject = fi.getLastObjectNumber();
        assert (newLastObject >= oldLastObject);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.proc, this, "truncate extend to: %d old last: %d   new last: %d", fileSize, oldLastObject, newLastObject);
        }
        if (sp.getOSDforObject(newLastObject) == relOsdId && newLastObject == oldLastObject) {
            this.truncateObject(fileId, newLastObject, sp, (int)(fileSize - sp.getObjectStartOffset(newLastObject)), relOsdId, cow, newObjVer);
        } else {
            if (oldLastObject > -1L && sp.isLocalObject(oldLastObject, relOsdId)) {
                this.truncateObject(fileId, oldLastObject, sp, sp.getStripeSizeForObject(oldLastObject), relOsdId, cow, newObjVer);
            }
            if (sp.isLocalObject(newLastObject, relOsdId)) {
                long version = newObjVer != null ? newObjVer : (cow.isCOW((int)newLastObject) ? fi.getLargestObjectVersion(newLastObject) + 1L : Math.max(1L, fi.getLargestObjectVersion(newLastObject)));
                int objSize = (int)(fileSize - sp.getObjectStartOffset(newLastObject));
                this.createPaddingObject(fileId, newLastObject, sp, version, objSize, fi);
            }
            for (long obj = newLastObject - 1L; obj > newLastObject - (long)sp.getWidth(); --obj) {
                long v;
                if (obj <= 0L || !sp.isLocalObject(obj, relOsdId) || (v = fi.getLatestObjectVersion(obj)) != 0L) continue;
                boolean isCow = cow.isCOW((int)obj);
                long newVersion = newObjVer != null ? newObjVer : (isCow ? fi.getLargestObjectVersion(obj) + 1L : Math.max(1L, fi.getLargestObjectVersion(obj)));
                this.createPaddingObject(fileId, obj, sp, newVersion, sp.getStripeSizeForObject(obj), fi);
            }
        }
        return newLastObject;
    }

    private void truncateObject(String fileId, long objNo, StripingPolicyImpl sp, int newSize, long relOsdId, CowPolicy cow, Long newObjVer) throws IOException {
        assert (newSize > 0) : "new size is " + newSize + " but should be > 0";
        assert (newSize <= sp.getStripeSizeForObject(objNo));
        assert (objNo >= 0L) : "objNo is " + objNo;
        assert ((long)sp.getOSDforObject(objNo) == relOsdId);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.proc, this, "truncate object to %d", newSize);
        }
        FileMetadata fi = this.layout.getFileMetadata(sp, fileId);
        boolean isCow = cow.isCOW((int)objNo);
        long newVersion = newObjVer != null ? newObjVer : (isCow ? fi.getLargestObjectVersion(objNo) + 1L : Math.max(1L, fi.getLatestObjectVersion(objNo)));
        this.layout.truncateObject(fileId, fi, objNo, newSize, newVersion, isCow);
    }

    private void createPaddingObject(String fileId, long objNo, StripingPolicyImpl sp, long version, int size, FileMetadata fi) throws IOException {
        this.layout.createPaddingObject(fileId, fi, objNo, version, size);
    }
}

