/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;

public class VersionTable {
    private static final long D_MAX = 2000L;
    private SortedMap<Long, Version> vt = new TreeMap<Long, Version>();
    private File vtFile;

    public VersionTable(File vtFile) {
        this.vtFile = vtFile;
    }

    public synchronized void load() throws IOException {
        if (this.vtFile == null) {
            throw new IOException("no source file specified");
        }
        this.vt.clear();
        FileInputStream fi = new FileInputStream(this.vtFile);
        ReusableBuffer buf = BufferPool.allocate((int)this.vtFile.length());
        fi.getChannel().read(buf.getBuffer());
        buf.position(0);
        while (buf.position() < buf.limit()) {
            long timestamp = buf.getLong();
            long fileSize = buf.getLong();
            long numObjs = buf.getLong();
            assert (numObjs <= Integer.MAX_VALUE) : "number of objects: " + numObjs + ", current limit = " + Integer.MAX_VALUE;
            int[] objVersions = new int[(int)numObjs];
            for (int i = 0; i < objVersions.length; ++i) {
                objVersions[i] = buf.getInt();
            }
            this.addVersion(timestamp, objVersions, fileSize);
        }
        BufferPool.free(buf);
        fi.close();
    }

    public synchronized void save() throws IOException {
        if (this.vtFile == null) {
            throw new IOException("no target file specified");
        }
        FileOutputStream fo = new FileOutputStream(this.vtFile);
        for (Map.Entry<Long, Version> entry : this.vt.entrySet()) {
            ReusableBuffer buf = BufferPool.allocate(24 + entry.getValue().getObjCount() * 32 / 8);
            buf.putLong(entry.getKey());
            buf.putLong(entry.getValue().getFileSize());
            buf.putLong(entry.getValue().getObjCount());
            for (int i = 0; i < entry.getValue().getObjCount(); ++i) {
                buf.putInt(entry.getValue().getObjVersion(i));
            }
            fo.write(buf.array());
            BufferPool.free(buf);
        }
        fo.close();
    }

    public Version getLatestVersionBefore(long timestamp) {
        try {
            return (Version)this.vt.get(this.vt.headMap(timestamp).lastKey());
        }
        catch (NoSuchElementException exc) {
            return Version.EMPTY_VERSION;
        }
    }

    public void addVersion(long timestamp, int[] objVersions, long fileSize) {
        this.vt.put(timestamp, new Version(objVersions, fileSize));
    }

    public void deleteVersion(long timestamp) {
        this.vt.remove(timestamp);
    }

    public synchronized Map<Integer, Set<Integer>> cleanup(long[] timestamps) {
        TreeMap<Long, Version> cleanedTable = new TreeMap<Long, Version>(this.vt);
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        Long[] tsArray = cleanedTable.keySet().toArray(new Long[cleanedTable.size()]);
        if (tsArray.length == 0) {
            return result;
        }
        TreeMap superseeded = new TreeMap();
        for (int i = 0; i < tsArray.length; ++i) {
            long currentTs = tsArray[i];
            long nextTs = i == tsArray.length - 1 ? Long.MAX_VALUE : tsArray[i + 1];
            boolean isSuperseeded = true;
            for (long t : timestamps) {
                if (currentTs - 2000L >= t || t >= nextTs + 2000L) continue;
                isSuperseeded = false;
                break;
            }
            if (!isSuperseeded) continue;
            superseeded.put(currentTs, cleanedTable.get(currentTs));
        }
        Iterator<Object> i$ = superseeded.keySet().iterator();
        while (i$.hasNext()) {
            long ts = (Long)i$.next();
            cleanedTable.remove(ts);
        }
        for (Version v : superseeded.values()) {
            for (int i = 0; i < v.objVersions.length; ++i) {
                int version = v.objVersions[i];
                if (VersionTable.isContained(i, version, cleanedTable)) continue;
                HashSet<Integer> versions = (HashSet<Integer>)result.get(i);
                if (versions == null) {
                    versions = new HashSet<Integer>();
                    result.put(i, versions);
                }
                versions.add(version);
            }
        }
        this.vt = cleanedTable;
        return result;
    }

    public long getVersionCount() {
        return this.vt.size();
    }

    public boolean isContained(long objNo, long objVer) {
        return VersionTable.isContained(objNo, objVer, this.vt);
    }

    private static boolean isContained(long objNo, long objVer, SortedMap<Long, Version> vtable) {
        assert (objNo <= Integer.MAX_VALUE);
        if (objVer == 0L) {
            return false;
        }
        for (Version versions : vtable.values()) {
            if (objNo >= (long)versions.getObjCount() || objVer != (long)versions.getObjVersion((int)objNo)) continue;
            return true;
        }
        return false;
    }

    public static class Version {
        protected static final Version EMPTY_VERSION = new Version(new int[0], 0L);
        private int[] objVersions;
        private long fileSize;

        public Version(int[] objVersions, long fileSize) {
            this.objVersions = objVersions;
            this.fileSize = fileSize;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public int getObjCount() {
            return this.objVersions.length;
        }

        public int getObjVersion(long objNo) {
            assert (objNo <= Integer.MAX_VALUE);
            return objNo >= (long)this.objVersions.length ? 0 : this.objVersions[(int)objNo];
        }
    }
}

