/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.vivaldi;

import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class VivaldiNode {
    private GlobalTypes.VivaldiCoordinates vCoordinates = GlobalTypes.VivaldiCoordinates.newBuilder().setLocalError(0.0).setXCoordinate(0.0).setYCoordinate(0.0).build();
    private final double CONSTANT_E = 0.1;
    private final double CONSTANT_C = 0.25;
    private final double MAX_MOVEMENT_RATIO = 0.1;

    public GlobalTypes.VivaldiCoordinates getCoordinates() {
        return this.vCoordinates;
    }

    private GlobalTypes.VivaldiCoordinates multiplyValueCoordinates(GlobalTypes.VivaldiCoordinates coordA, double value) {
        GlobalTypes.VivaldiCoordinates.Builder ret = GlobalTypes.VivaldiCoordinates.newBuilder();
        ret.setXCoordinate(coordA.getXCoordinate() * value);
        ret.setYCoordinate(coordA.getYCoordinate() * value);
        ret.setLocalError(0.0);
        return ret.build();
    }

    private GlobalTypes.VivaldiCoordinates addCoordinates(GlobalTypes.VivaldiCoordinates coordA, GlobalTypes.VivaldiCoordinates coordB) {
        GlobalTypes.VivaldiCoordinates.Builder ret = GlobalTypes.VivaldiCoordinates.newBuilder();
        ret.setXCoordinate(coordA.getXCoordinate() + coordB.getXCoordinate());
        ret.setYCoordinate(coordA.getYCoordinate() + coordB.getYCoordinate());
        ret.setLocalError(0.0);
        return ret.build();
    }

    private GlobalTypes.VivaldiCoordinates subtractCoordinates(GlobalTypes.VivaldiCoordinates coordA, GlobalTypes.VivaldiCoordinates coordB) {
        return this.addCoordinates(coordA, this.multiplyValueCoordinates(coordB, -1.0));
    }

    private double scalarProductCoordinates(GlobalTypes.VivaldiCoordinates coordA, GlobalTypes.VivaldiCoordinates coordB) {
        double ret = 0.0;
        ret += coordA.getXCoordinate() * coordB.getXCoordinate();
        return ret += coordA.getYCoordinate() * coordB.getYCoordinate();
    }

    private double magnitudeCoordinates(GlobalTypes.VivaldiCoordinates coordA) {
        return Math.sqrt(this.scalarProductCoordinates(coordA, coordA));
    }

    private GlobalTypes.VivaldiCoordinates getUnitaryCoordinates(GlobalTypes.VivaldiCoordinates coordA) {
        double magn = this.magnitudeCoordinates(coordA);
        return this.multiplyValueCoordinates(coordA, 1.0 / magn);
    }

    private GlobalTypes.VivaldiCoordinates getRandomCoordinates() {
        GlobalTypes.VivaldiCoordinates.Builder coordA = GlobalTypes.VivaldiCoordinates.newBuilder();
        coordA.setXCoordinate(Math.random() * 2.0 - 1.0);
        coordA.setYCoordinate(Math.random() * 2.0 - 1.0);
        coordA.setLocalError(0.0);
        return coordA.build();
    }

    public static double calculateDistance(GlobalTypes.VivaldiCoordinates pointA, GlobalTypes.VivaldiCoordinates pointB) {
        VivaldiNode auxNode = new VivaldiNode();
        return auxNode.magnitudeCoordinates(auxNode.subtractCoordinates(pointA, pointB));
    }

    public static String coordinatesToString(GlobalTypes.VivaldiCoordinates vc) {
        StringBuffer sb = new StringBuffer(24);
        OutputUtils.writeHexLong(sb, Double.doubleToRawLongBits(vc.getXCoordinate()));
        OutputUtils.writeHexLong(sb, Double.doubleToRawLongBits(vc.getYCoordinate()));
        OutputUtils.writeHexLong(sb, Double.doubleToRawLongBits(vc.getLocalError()));
        return sb.toString();
    }

    public static GlobalTypes.VivaldiCoordinates stringToCoordinates(String coordinates) {
        GlobalTypes.VivaldiCoordinates.Builder vc = GlobalTypes.VivaldiCoordinates.newBuilder();
        vc.setXCoordinate(Double.longBitsToDouble(OutputUtils.readHexLong(coordinates, 0)));
        vc.setYCoordinate(Double.longBitsToDouble(OutputUtils.readHexLong(coordinates, 16)));
        vc.setLocalError(Double.longBitsToDouble(OutputUtils.readHexLong(coordinates, 32)));
        return vc.build();
    }

    public boolean recalculatePosition(GlobalTypes.VivaldiCoordinates coordinatesJ, long measuredRTT, boolean forceRecalculation) {
        assert (measuredRTT >= 0L) : "Wrong RTT";
        boolean ret = true;
        double localError = this.vCoordinates.getLocalError();
        GlobalTypes.VivaldiCoordinates subtractionVector = this.subtractCoordinates(this.vCoordinates, coordinatesJ);
        double subtractionMagnitude = this.magnitudeCoordinates(subtractionVector);
        double weight = 0.0;
        if (measuredRTT == 0L) {
            measuredRTT = 1L;
        }
        double relativeError = Math.abs(subtractionMagnitude - (double)measuredRTT) / (double)measuredRTT;
        if (localError <= 0.0) {
            weight = 1.0;
        } else if (coordinatesJ.getLocalError() > 0.0) {
            weight = localError / (localError + Math.abs(coordinatesJ.getLocalError()));
        }
        double delta = 0.25 * weight;
        double estimatedMovement = ((double)measuredRTT - subtractionMagnitude) * delta;
        if (forceRecalculation || subtractionMagnitude <= 0.0 || estimatedMovement < 0.0 || Math.abs(estimatedMovement) < subtractionMagnitude * 0.1) {
            localError = localError <= 0.0 ? Math.abs(subtractionMagnitude - (double)measuredRTT) : relativeError * 0.1 * weight + localError * (1.0 - 0.1 * weight);
            GlobalTypes.VivaldiCoordinates additionVector = null;
            if (subtractionMagnitude > 0.0) {
                additionVector = this.multiplyValueCoordinates(this.getUnitaryCoordinates(subtractionVector), estimatedMovement);
            } else {
                GlobalTypes.VivaldiCoordinates randomCoords = this.getRandomCoordinates();
                additionVector = this.multiplyValueCoordinates(this.getUnitaryCoordinates(randomCoords), estimatedMovement);
            }
            this.vCoordinates = this.addCoordinates(this.vCoordinates, additionVector);
            this.vCoordinates = this.vCoordinates.toBuilder().setLocalError(localError).build();
        } else {
            ret = false;
        }
        return ret;
    }
}

