/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd.vivaldi;

import java.util.Random;

public class ZipfGenerator {
    private Random rnd = new Random(System.currentTimeMillis());
    private int size;
    private double skew;
    private double bottom;

    public ZipfGenerator(int size, double skew) {
        this.skew = skew;
        this.setSize(size);
    }

    public int next() {
        int rank = -1;
        double frequency = 0.0;
        double dice = 0.0;
        while (dice >= frequency) {
            rank = this.rnd.nextInt(this.size);
            frequency = this.getProbability(rank + 1);
            dice = this.rnd.nextDouble();
        }
        return rank;
    }

    public double getProbability(int rank) {
        if (rank == 0) {
            throw new RuntimeException("getProbability - rank must be > 0");
        }
        return 1.0 / Math.pow(rank, this.skew) / this.bottom;
    }

    public void setSize(int newSize) {
        this.size = newSize;
        this.bottom = 0.0;
        for (int i = 1; i <= this.size; ++i) {
            this.bottom += 1.0 / Math.pow(i, this.skew);
        }
    }

    public double[] getDistribution() {
        double[] result = new double[this.size];
        for (int i = 1; i <= this.size; ++i) {
            result[i - 1] = this.getProbability(i);
        }
        return result;
    }

    public int[] getRankArray(int totalEvents) {
        int[] result = new int[this.size];
        for (int i = 0; i < totalEvents; ++i) {
            int rank;
            int n = rank = this.next();
            result[n] = result[n] + 1;
        }
        return result;
    }
}

