/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.pbrpc.generatedinterfaces;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class DIRServiceClient {
    private RPCNIOSocketClient client;
    private InetSocketAddress defaultServer;

    public DIRServiceClient(RPCNIOSocketClient client, InetSocketAddress defaultServer) {
        this.client = client;
        this.defaultServer = defaultServer;
    }

    public RPCResponse<DIR.AddressMappingSet> xtreemfs_address_mappings_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.addressMappingGetRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.AddressMappingSet> response = new RPCResponse<DIR.AddressMappingSet>(DIR.AddressMappingSet.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 1, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.AddressMappingSet> xtreemfs_address_mappings_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException {
        DIR.addressMappingGetRequest msg = DIR.addressMappingGetRequest.newBuilder().setUuid(uuid).build();
        return this.xtreemfs_address_mappings_get(server, authHeader, userCreds, msg);
    }

    public RPCResponse xtreemfs_address_mappings_remove(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.addressMappingGetRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 10001, 2, input, null, response, false);
        return response;
    }

    public RPCResponse xtreemfs_address_mappings_remove(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException {
        DIR.addressMappingGetRequest msg = DIR.addressMappingGetRequest.newBuilder().setUuid(uuid).build();
        return this.xtreemfs_address_mappings_remove(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.addressMappingSetResponse> xtreemfs_address_mappings_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.AddressMappingSet input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.addressMappingSetResponse> response = new RPCResponse<DIR.addressMappingSetResponse>(DIR.addressMappingSetResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 3, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.addressMappingSetResponse> xtreemfs_address_mappings_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, List<DIR.AddressMapping> mappings) throws IOException {
        DIR.AddressMappingSet msg = DIR.AddressMappingSet.newBuilder().addAllMappings(mappings).build();
        return this.xtreemfs_address_mappings_set(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.DirService> xtreemfs_discover_dir(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.DirService> response = new RPCResponse<DIR.DirService>(DIR.DirService.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 4, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.DirService> xtreemfs_discover_dir(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.xtreemfs_discover_dir(server, authHeader, userCreds, null);
    }

    public RPCResponse<DIR.globalTimeSGetResponse> xtreemfs_global_time_s_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.globalTimeSGetResponse> response = new RPCResponse<DIR.globalTimeSGetResponse>(DIR.globalTimeSGetResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 5, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.globalTimeSGetResponse> xtreemfs_global_time_s_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.xtreemfs_global_time_s_get(server, authHeader, userCreds, null);
    }

    public RPCResponse xtreemfs_service_deregister(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceDeregisterRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 10001, 6, input, null, response, false);
        return response;
    }

    public RPCResponse xtreemfs_service_deregister(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException {
        DIR.serviceDeregisterRequest msg = DIR.serviceDeregisterRequest.newBuilder().setUuid(uuid).build();
        return this.xtreemfs_service_deregister(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.ServiceSet> xtreemfs_service_get_by_name(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceGetByNameRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.ServiceSet> response = new RPCResponse<DIR.ServiceSet>(DIR.ServiceSet.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 7, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.ServiceSet> xtreemfs_service_get_by_name(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String name) throws IOException {
        DIR.serviceGetByNameRequest msg = DIR.serviceGetByNameRequest.newBuilder().setName(name).build();
        return this.xtreemfs_service_get_by_name(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.ServiceSet> xtreemfs_service_get_by_type(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceGetByTypeRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.ServiceSet> response = new RPCResponse<DIR.ServiceSet>(DIR.ServiceSet.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 8, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.ServiceSet> xtreemfs_service_get_by_type(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.ServiceType type) throws IOException {
        DIR.serviceGetByTypeRequest msg = DIR.serviceGetByTypeRequest.newBuilder().setType(type).build();
        return this.xtreemfs_service_get_by_type(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.ServiceSet> xtreemfs_service_get_by_uuid(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceGetByUUIDRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.ServiceSet> response = new RPCResponse<DIR.ServiceSet>(DIR.ServiceSet.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 9, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.ServiceSet> xtreemfs_service_get_by_uuid(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String name) throws IOException {
        DIR.serviceGetByUUIDRequest msg = DIR.serviceGetByUUIDRequest.newBuilder().setName(name).build();
        return this.xtreemfs_service_get_by_uuid(server, authHeader, userCreds, msg);
    }

    public RPCResponse xtreemfs_service_offline(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceGetByUUIDRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 10001, 10, input, null, response, false);
        return response;
    }

    public RPCResponse xtreemfs_service_offline(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String name) throws IOException {
        DIR.serviceGetByUUIDRequest msg = DIR.serviceGetByUUIDRequest.newBuilder().setName(name).build();
        return this.xtreemfs_service_offline(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.serviceRegisterResponse> xtreemfs_service_register(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.serviceRegisterRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.serviceRegisterResponse> response = new RPCResponse<DIR.serviceRegisterResponse>(DIR.serviceRegisterResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 11, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.serviceRegisterResponse> xtreemfs_service_register(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.Service service) throws IOException {
        DIR.serviceRegisterRequest msg = DIR.serviceRegisterRequest.newBuilder().setService(service).build();
        return this.xtreemfs_service_register(server, authHeader, userCreds, msg);
    }

    public RPCResponse xtreemfs_checkpoint(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 10001, 20, input, null, response, false);
        return response;
    }

    public RPCResponse xtreemfs_checkpoint(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.xtreemfs_checkpoint(server, authHeader, userCreds, null);
    }

    public RPCResponse xtreemfs_shutdown(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, Common.emptyRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 10001, 21, input, null, response, false);
        return response;
    }

    public RPCResponse xtreemfs_shutdown(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds) throws IOException {
        return this.xtreemfs_shutdown(server, authHeader, userCreds, null);
    }

    public RPCResponse<DIR.Configuration> xtreemfs_configuration_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.configurationGetRequest input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.Configuration> response = new RPCResponse<DIR.Configuration>(DIR.Configuration.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 22, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.Configuration> xtreemfs_configuration_get(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid) throws IOException {
        DIR.configurationGetRequest msg = DIR.configurationGetRequest.newBuilder().setUuid(uuid).build();
        return this.xtreemfs_configuration_get(server, authHeader, userCreds, msg);
    }

    public RPCResponse<DIR.configurationSetResponse> xtreemfs_configuration_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, DIR.Configuration input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<DIR.configurationSetResponse> response = new RPCResponse<DIR.configurationSetResponse>(DIR.configurationSetResponse.getDefaultInstance());
        this.client.sendRequest(server, authHeader, userCreds, 10001, 23, input, null, response, false);
        return response;
    }

    public RPCResponse<DIR.configurationSetResponse> xtreemfs_configuration_set(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, String uuid, List<GlobalTypes.KeyValuePair> parameter, long version) throws IOException {
        DIR.Configuration msg = DIR.Configuration.newBuilder().setUuid(uuid).addAllParameter(parameter).setVersion(version).build();
        return this.xtreemfs_configuration_set(server, authHeader, userCreds, msg);
    }

    public RPCResponse xtreemfs_vivaldi_client_update(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, GlobalTypes.VivaldiCoordinates input) throws IOException {
        if (server == null) {
            server = this.defaultServer;
        }
        if (server == null) {
            throw new IllegalArgumentException("defaultServer must be set in constructor if you want to pass null as server in calls");
        }
        RPCResponse<Object> response = new RPCResponse<Object>(null);
        this.client.sendRequest(server, authHeader, userCreds, 10001, 24, input, null, response, false);
        return response;
    }

    public RPCResponse xtreemfs_vivaldi_client_update(InetSocketAddress server, RPC.Auth authHeader, RPC.UserCredentials userCreds, double x_coordinate, double y_coordinate, double local_error) throws IOException {
        GlobalTypes.VivaldiCoordinates msg = GlobalTypes.VivaldiCoordinates.newBuilder().setXCoordinate(x_coordinate).setYCoordinate(y_coordinate).setLocalError(local_error).build();
        return this.xtreemfs_vivaldi_client_update(server, authHeader, userCreds, msg);
    }

    public boolean clientIsAlive() {
        return this.client.isAlive();
    }
}

