/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.sandbox;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.xtreemfs.common.libxtreemfs.Client;
import org.xtreemfs.common.libxtreemfs.ClientFactory;
import org.xtreemfs.common.libxtreemfs.FileHandle;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.Volume;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.PBRPCServiceURL;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class ExampleLibxtreemfsWithSSL {
    public static final String CERT_DIR = "tests/certs/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: <URL to existing volume e.g., pbrpcs://localhost/regular>");
            return;
        }
        Client client = null;
        FileHandle fileHandle = null;
        try {
            int lastSlashIndex = args[0].lastIndexOf(47);
            PBRPCServiceURL url = new PBRPCServiceURL(args[0].substring(0, lastSlashIndex), "pbrpc", GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber());
            String volumeName = args[0].substring(lastSlashIndex + 1);
            Options options = new Options();
            RPC.UserCredentials userCredentials = RPC.UserCredentials.newBuilder().setUsername(System.getProperty("user.name")).addGroups("root").build();
            SSLOptions sslOptions = url.getProtocol().equals("pbrpc") ? null : new SSLOptions(new FileInputStream("tests/certs/Client.p12"), "passphrase", "PKCS12", new FileInputStream("tests/certs/trusted.jks"), "passphrase", "JKS", false, false, null, null);
            Logging.start(4, new Logging.Category[0]);
            client = ClientFactory.createClient(url.getHost() + ":" + url.getPort(), userCredentials, sslOptions, options);
            client.start();
            Volume volume = client.openVolume(volumeName, sslOptions, options);
            fileHandle = volume.openFile(userCredentials, "/example_libxtreemfs_test_" + String.format("%03d", (int)(Math.random() * 1000.0)) + ".bin", GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_CREAT.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_EXCL.getNumber() | GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber(), 420);
            byte[] data = new byte[131072];
            Arrays.fill(data, (byte)-85);
            for (int offset = 0; offset < 0x100000; offset += data.length) {
                fileHandle.write(userCredentials, data, data.length, offset);
            }
            byte[] readData = new byte[data.length];
            for (int offset = 0; offset < 0x100000; offset += data.length) {
                int readCount = fileHandle.read(userCredentials, readData, data.length, offset);
                if (readCount != data.length) {
                    throw new IOException("Read less data than expected: " + readCount + " bytes instead of: " + data.length);
                }
                if (Arrays.equals(readData, data)) continue;
                throw new IOException("Read data differs from written chunk at offset: " + offset);
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred: " + e.getMessage() + "\n Full Stacktrace:\n" + e.getStackTrace());
            return;
        }
        finally {
            if (fileHandle != null) {
                try {
                    fileHandle.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to close() the file: " + e.getMessage() + "\n Full Stacktrace:\n" + e.getStackTrace());
                    return;
                }
            }
            if (client != null) {
                client.shutdown();
            }
            System.out.println("If no errors are shown, the example was successfully executed.");
        }
    }
}

