/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.sandbox.tests;

import java.net.InetSocketAddress;
import org.xtreemfs.common.clients.Client;
import org.xtreemfs.common.clients.File;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.common.clients.Volume;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;

public class JavaClientTest {
    private static final byte[] buf = new byte[131072];
    private static final int numThreads = 40;
    private static final int numFiles = 3000;
    private static final int numAppends = 3;
    private Client c;
    private Volume v;

    public void init() throws Exception {
        RPC.UserCredentials uc = RPC.UserCredentials.newBuilder().setUsername("stender").addGroups("users").build();
        this.c = new Client(new InetSocketAddress[]{new InetSocketAddress(32638)}, 60000, 120000, null);
        this.c.start();
        this.v = this.c.getVolume("test", uc);
    }

    public void run() throws Exception {
        Thread[] threads = new Thread[40];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = this.getWriter(i);
        }
        for (Thread th : threads) {
            th.start();
        }
        for (Thread th : threads) {
            th.join();
        }
    }

    public void stop() {
        this.c.stop();
    }

    private Thread getWriter(final int num) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    File dir = JavaClientTest.this.v.getFile(num + "");
                    if (!dir.exists()) {
                        dir.mkdir(511);
                    }
                    for (int i = 0; i < 3000; ++i) {
                        File file = JavaClientTest.this.v.getFile(num + "/" + i + ".txt");
                        RandomAccessFile raf = file.open("rw", 511);
                        for (int j = 0; j < 3; ++j) {
                            raf.write(buf, 0, buf.length);
                        }
                        raf.close();
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
    }

    public static void main(String[] args) throws Exception {
        Logging.start(4, new Logging.Category[0]);
        JavaClientTest t = new JavaClientTest();
        t.init();
        t.run();
        t.stop();
    }

    static {
        for (int i = 0; i < buf.length; ++i) {
            JavaClientTest.buf[i] = -1;
        }
    }
}

