/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.sandbox.tests;

import java.io.File;
import java.io.IOException;

public class MRCStressTest {
    private static int fc = 0;
    private static int dc = 0;
    private static final Object fcLock = new Object();
    private static final Object dcLock = new Object();

    public static void main(String[] args) throws Exception {
        String rootDir = "/tmp/xtreemfs";
        int numberOfThreads = 30;
        int depth = 4;
        int minSpread = 2;
        int maxSpread = 5;
        boolean minFilesPerDir = false;
        int maxFilesPerDir = 10;
        boolean minNameLength = true;
        int maxNameLength = 32;
        long startTime = System.currentTimeMillis();
        Thread[] threads = new Thread[30];
        for (int i = 0; i < 30; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        MRCStressTest.createRandomTree("/tmp/xtreemfs", 4, 2, 5, 0, 10, 1, 32);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
        }
        for (Thread th : threads) {
            th.start();
        }
        for (Thread th : threads) {
            th.join();
        }
        long time = System.currentTimeMillis() - startTime;
        System.out.println("created " + fc + " files and " + dc + " directories in " + time + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createRandomTree(String rootDir, int depth, int minSpread, int maxSpread, int minFilesPerNode, int maxFilesPerNode, int minNameLength, int maxNameLength) throws IOException {
        int spread = MRCStressTest.randomNumber(minSpread, maxSpread);
        for (int i = 0; i < spread; ++i) {
            String nestedDir = rootDir + "/" + MRCStressTest.randomFileName(minNameLength, maxNameLength);
            if (new File(nestedDir).mkdir()) {
                Object object = dcLock;
                synchronized (object) {
                    ++dc;
                }
            } else {
                System.err.println("could not create directory " + nestedDir);
            }
            int fileCount = MRCStressTest.randomNumber(minFilesPerNode, maxFilesPerNode);
            for (int j = 0; j < fileCount; ++j) {
                String fileName = nestedDir + "/" + MRCStressTest.randomFileName(minNameLength, maxNameLength);
                if (new File(fileName).createNewFile()) {
                    Object object = fcLock;
                    synchronized (object) {
                        ++fc;
                        continue;
                    }
                }
                System.err.println("could not create file " + nestedDir);
            }
            if (depth <= 1) continue;
            MRCStressTest.createRandomTree(nestedDir, depth - 1, minSpread, maxSpread, minFilesPerNode, maxFilesPerNode, minNameLength, maxNameLength);
        }
    }

    private static int randomNumber(int lowerBound, int upperBound) {
        return (int)(Math.random() * (double)(upperBound - lowerBound + 1) + (double)lowerBound);
    }

    private static String randomFileName(int minLength, int maxLength) {
        char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        int length = MRCStressTest.randomNumber(minLength, maxLength);
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = allowedChars[(int)(Math.random() * (double)allowedChars.length)];
        }
        return new String(chars);
    }
}

