/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.sandbox.tests;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.xtreemfs.common.clients.Client;
import org.xtreemfs.common.clients.File;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.common.clients.Volume;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.CLOption;
import org.xtreemfs.foundation.util.CLOptionParser;
import org.xtreemfs.foundation.util.InvalidUsageException;
import org.xtreemfs.foundation.util.PBRPCServiceURL;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class ReplicatedTortureXtreemFS {
    public static void main(String[] args) {
        try {
            CLOptionParser parser = new CLOptionParser("TortureXtreemFS");
            CLOption.StringValue optVolname = (CLOption.StringValue)parser.addOption(new CLOption.StringValue("v", "volname", "volume name"));
            CLOption.StringValue optPath = (CLOption.StringValue)parser.addOption(new CLOption.StringValue("p", "path", "filename (default is torture.dat)"));
            CLOption.StringValue optPKCS12file = (CLOption.StringValue)parser.addOption(new CLOption.StringValue(null, "pkcs12-file-path", ""));
            CLOption.StringValue optPKCS12passphrase = (CLOption.StringValue)parser.addOption(new CLOption.StringValue(null, "pkcs12-passphrase", ""));
            CLOption.StringValue optSSLProtocol = (CLOption.StringValue)parser.addOption(new CLOption.StringValue(null, "ssl-protocol", "SSL/TLS version to use: sslv3, ssltls, tlsv1, tlsv11, tlsv12. 'ssltls' (default) accepts all versions, the others accept only the exact version they name. 'tlsv12' is available in JDK 7+ only. 'tlsv11' comes with JDK 6 or 7, depending on the vendor."));
            CLOption.Switch optRandomOnly = (CLOption.Switch)parser.addOption(new CLOption.Switch("r", "random", "execute only random test"));
            CLOption.IntegerValue optReplicas = (CLOption.IntegerValue)parser.addOption(new CLOption.IntegerValue("n", "num-replicas", "number of replicas to use (default is 1)"));
            CLOption.Switch optTrunc = (CLOption.Switch)parser.addOption(new CLOption.Switch("t", "truncae", "truncate to 0 instead of creating a new file"));
            CLOption.Switch optAddR = (CLOption.Switch)parser.addOption(new CLOption.Switch("a", "addreplica", "adds a new replica after writing and reads from it"));
            parser.parse(args);
            List<String> arguments = parser.getArguments();
            Logging.start(4, new Logging.Category[0]);
            TimeSync.initializeLocal(50);
            if (arguments.size() != 1) {
                ReplicatedTortureXtreemFS.usage();
                return;
            }
            String path = optPath.isSet() ? optPath.getValue() : "/torture.data";
            String volname = optVolname.isSet() ? optVolname.getValue() : "test";
            PBRPCServiceURL dirURL = new PBRPCServiceURL(arguments.get(0), "pbrpc", GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber());
            boolean useSSL = dirURL.getProtocol().equals("pbrpcg") || dirURL.getProtocol().equals("pbrpcs");
            boolean randomOnly = optRandomOnly.isSet();
            boolean addReplica = optAddR.isSet();
            int replicas = optReplicas.isSet() ? optReplicas.getValue() : 1;
            SSLOptions sslOptions = null;
            if (useSSL) {
                if (!optPKCS12file.isSet()) {
                    throw new InvalidUsageException("must specify a PCKS#12 file with credentials for (grid)SSL mode, use " + optPKCS12file.getName());
                }
                if (!optPKCS12passphrase.isSet()) {
                    throw new InvalidUsageException("must specify a PCKS#12 passphrase for (grid)SSL mode, use " + optPKCS12passphrase.getName());
                }
                String sslProtocol = optSSLProtocol.isSet() ? optSSLProtocol.getValue() : null;
                boolean gridSSL = dirURL.getProtocol().equals("pbrpcg");
                sslOptions = new SSLOptions(new FileInputStream(optPKCS12file.getValue()), optPKCS12passphrase.getValue(), "PKCS12", null, null, "none", false, gridSSL, sslProtocol, null);
            }
            Client c = new Client(new InetSocketAddress[]{new InetSocketAddress(dirURL.getHost(), dirURL.getPort())}, 30000, 300000, sslOptions);
            c.start();
            System.out.println("file size from 64k to 512MB with record length from 4k to 1M");
            int MIN_FS = 65536;
            int MAX_FS = 0x20000000;
            int MIN_REC = 4096;
            int MAX_REC = 0x100000;
            ArrayList<String> grs = new ArrayList<String>(1);
            grs.add("torture");
            RPC.UserCredentials uc = RPC.UserCredentials.newBuilder().setUsername("torture").addGroups("users").build();
            try {
                GlobalTypes.StripingPolicy sp = GlobalTypes.StripingPolicy.newBuilder().setType(GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0).setWidth(1).setStripeSize(128).build();
                c.createVolume(volname, RPCAuthentication.authNone, uc, sp, GlobalTypes.AccessControlPolicyType.ACCESS_CONTROL_POLICY_POSIX, 511);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Volume v = c.getVolume(volname, uc);
            if (replicas > 1) {
                File f = v.getFile("/");
                f.setDefaultReplication("WaR1", replicas);
            }
            RandomAccessFile tmp = v.getFile(path + ".tmp").open("rw", 438);
            if (!randomOnly) {
                int recsize;
                int fsize;
                for (int fsize2 = 65536; fsize2 <= 0x20000000; fsize2 *= 2) {
                    for (int recsize2 = 4096; recsize2 <= 0x100000; recsize2 *= 2) {
                        if (!ReplicatedTortureXtreemFS.testSequential_write(fsize2, recsize2, path, v)) continue;
                    }
                }
                System.out.println("waiting for files to be closed on OSD (100 seconds)");
                Thread.sleep(100000L);
                int readRepl = replicas - 1;
                if (addReplica) {
                    for (fsize = 65536; fsize <= 0x20000000; fsize *= 2) {
                        int numRecs;
                        for (recsize = 4096; recsize <= 0x100000 && (numRecs = fsize / recsize) != 0; recsize *= 2) {
                            File f = v.getFile(path + "." + fsize + "-" + recsize);
                            f.addReplica(1, f.getSuitableOSDs(1), 0);
                        }
                    }
                    readRepl = replicas;
                }
                for (fsize = 65536; fsize <= 0x20000000; fsize *= 2) {
                    for (recsize = 4096; recsize <= 0x100000; recsize *= 2) {
                        if (!ReplicatedTortureXtreemFS.testSequential_read(fsize, recsize, path, v, readRepl)) continue;
                    }
                }
            }
            System.out.println("finished");
            c.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean testSequential_write(int fsize, int recsize, String path, Volume v) throws InterruptedException, Exception, IOException {
        int numRecs = fsize / recsize;
        if (numRecs == 0) {
            return true;
        }
        byte[] sendBuffer = new byte[recsize];
        for (int i = 0; i < recsize; ++i) {
            sendBuffer[i] = (byte)(i % 26 + 65);
        }
        long tStart = System.currentTimeMillis();
        File f = v.getFile(path + "." + fsize + "-" + recsize);
        RandomAccessFile raf = f.open("rw", 438);
        long tOpen = System.currentTimeMillis();
        long bytesWritten = 0L;
        long tWrite = 0L;
        for (int rec = 0; rec < numRecs; ++rec) {
            long tmpStart = System.currentTimeMillis();
            bytesWritten += (long)raf.write(sendBuffer, 0, recsize);
            tWrite += System.currentTimeMillis() - tmpStart;
        }
        assert (bytesWritten == (long)(numRecs * recsize));
        raf.flush();
        raf.seek(0L);
        long tFlush = System.currentTimeMillis();
        raf.close();
        double writeRate = (double)fsize / 1024.0 / ((double)tWrite / 1000.0);
        System.out.format("fs: %8d   bs: %8d    write: %6d ms   %6.0f kb/s\n", fsize / 1024, recsize, tWrite, writeRate);
        return false;
    }

    private static boolean testSequential_read(int fsize, int recsize, String path, Volume v, int forceReplica) throws InterruptedException, Exception, IOException {
        int numRecs = fsize / recsize;
        if (numRecs == 0) {
            return true;
        }
        byte[] sendBuffer = new byte[recsize];
        for (int i = 0; i < recsize; ++i) {
            sendBuffer[i] = (byte)(i % 26 + 65);
        }
        long tStart = System.currentTimeMillis();
        File f = v.getFile(path + "." + fsize + "-" + recsize);
        RandomAccessFile raf = f.open("rw", 438);
        raf.forceReplica(forceReplica);
        long tOpen = System.currentTimeMillis();
        long tRead = 0L;
        byte[] readBuffer = new byte[recsize];
        for (int rec = 0; rec < numRecs; ++rec) {
            long tmpStart = System.currentTimeMillis();
            int bytesRead = raf.read(readBuffer, 0, recsize);
            tRead += System.currentTimeMillis() - tmpStart;
            if (bytesRead != recsize) {
                System.out.println("PREMATURE END-OF-FILE AT " + rec * recsize);
                System.out.println("expected " + recsize + " bytes");
                System.out.println("got " + bytesRead + " bytes");
                System.exit(1);
            }
            for (int i = 0; i < recsize; ++i) {
                if (readBuffer[i] == (byte)(i % 26 + 65)) continue;
                System.out.println("INVALID CONTENT AT " + (rec * recsize + i));
                System.out.println("expected:  " + (byte)(i % 26 + 65));
                System.out.println("got     : " + readBuffer[i]);
                System.exit(1);
            }
        }
        raf.close();
        f.delete();
        long tDelete = System.currentTimeMillis();
        double readRate = (double)fsize / 1024.0 / ((double)tRead / 1000.0);
        System.out.format("fs: %8d   bs: %8d                                      read: %6d ms   %6.0f kb/s\n", fsize / 1024, recsize, tRead, readRate);
        return false;
    }

    private static void usage() {
        System.out.println("usage: torture [options] <dir_url> <mrc_url>");
        System.out.println("  -v <volume name>  name of the volume on the mrc (default: test)");
        System.out.println("  -p <path>   filename to use for measurements (default: /torture.dat)");
        System.out.println("            In case of a secured URL ('https://...'), it is necessary to also specify SSL credentials:");
        System.out.println("              -c  <creds_file>         a PKCS#12 file containing user credentials");
        System.out.println("              -cpass <creds_passphrase>   a pass phrase to decrypt the the user credentials file");
        System.out.println("              -t  <trusted_CAs>        a PKCS#12 file containing a set of certificates from trusted CAs");
        System.out.println("              -tpass <trusted_passphrase> a pass phrase to decrypt the trusted CAs file");
        System.out.println("  -h        show usage info");
    }
}

