/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.sandbox.tests;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.CLIParser;

public class TortureLocalFS {
    public static void main(String[] args) {
        try {
            int recsize;
            int fsize;
            HashMap<String, CLIParser.CliOption> options = new HashMap<String, CLIParser.CliOption>();
            ArrayList<String> arguments = new ArrayList<String>(0);
            options.put("p", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING));
            options.put("r", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH));
            CLIParser.parseCLI(args, options, arguments);
            Logging.start(4, new Logging.Category[0]);
            TimeSync.initialize(null, 10000, 50);
            if (arguments.size() != 0) {
                TortureLocalFS.usage();
                return;
            }
            String path = ((CLIParser.CliOption)options.get((Object)"p")).stringValue != null ? ((CLIParser.CliOption)options.get((Object)"p")).stringValue : "./torture.data";
            int MIN_FS = 65536;
            int MAX_FS = 0x20000000;
            int MIN_REC = 4096;
            int MAX_REC = 0x100000;
            if (!((CLIParser.CliOption)options.get((Object)"r")).switchValue.booleanValue()) {
                for (fsize = 65536; fsize <= 0x20000000; fsize *= 2) {
                    for (recsize = 4096; recsize <= 0x100000; recsize *= 2) {
                        if (!TortureLocalFS.testSequential(fsize, recsize, path)) continue;
                    }
                }
            }
            System.out.println("\nrandom test\n");
            for (fsize = 65536; fsize <= 0x20000000; fsize *= 2) {
                for (recsize = 4096; recsize <= 0x100000; recsize *= 2) {
                    if (!TortureLocalFS.testRandom(fsize, recsize, path)) continue;
                }
            }
            System.out.println("finished");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean testSequential(int fsize, int recsize, String path) throws InterruptedException, Exception, IOException {
        int numRecs = fsize / recsize;
        if (numRecs == 0) {
            return true;
        }
        byte[] sendBuffer = new byte[recsize];
        for (int i = 0; i < recsize; ++i) {
            sendBuffer[i] = (byte)(i % 26 + 65);
        }
        long tStart = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(path, "rw");
        long tOpen = System.currentTimeMillis();
        long bytesWritten = 0L;
        long tWrite = 0L;
        for (int rec = 0; rec < numRecs; ++rec) {
            long tmpStart = System.currentTimeMillis();
            raf.write(sendBuffer, 0, recsize);
            bytesWritten += (long)recsize;
            tWrite += System.currentTimeMillis() - tmpStart;
        }
        assert (bytesWritten == (long)(numRecs * recsize));
        raf.getFD().sync();
        raf.seek(0L);
        long tFlush = System.currentTimeMillis();
        long tRead = 0L;
        byte[] readBuffer = new byte[recsize];
        for (int rec = 0; rec < numRecs; ++rec) {
            long tmpStart = System.currentTimeMillis();
            int bytesRead = raf.read(readBuffer, 0, recsize);
            tRead += System.currentTimeMillis() - tmpStart;
            if (bytesRead != recsize) {
                System.out.println("PREMATURE END-OF-FILE AT " + rec * recsize);
                System.out.println("expected " + recsize + " bytes");
                System.out.println("got " + bytesRead + " bytes");
                System.exit(1);
            }
            for (int i = 0; i < recsize; ++i) {
                if (readBuffer[i] == (byte)(i % 26 + 65)) continue;
                System.out.println("INVALID CONTENT AT " + (rec * recsize + i));
                System.out.println("expected:  " + (byte)(i % 26 + 65));
                System.out.println("got     : " + readBuffer[i]);
                System.exit(1);
            }
        }
        File f = new File(path);
        f.delete();
        long tDelete = System.currentTimeMillis();
        double writeRate = (double)fsize / 1024.0 / ((double)tWrite / 1000.0);
        double readRate = (double)fsize / 1024.0 / ((double)tRead / 1000.0);
        System.out.format("fs: %8d   bs: %8d    write: %6d ms   %6.0f kb/s    read: %6d ms   %6.0f kb/s\n", fsize / 1024, recsize, tWrite, writeRate, tRead, readRate);
        return false;
    }

    private static boolean testRandom(int fsize, int recsize, String path) throws InterruptedException, Exception, IOException {
        int numRecs = fsize / recsize;
        int[] skips = new int[numRecs];
        if (numRecs == 0) {
            return true;
        }
        byte[] sendBuffer = new byte[recsize];
        for (int i = 0; i < recsize; ++i) {
            sendBuffer[i] = (byte)(i % 26 + 65);
        }
        long tStart = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(path, "rw");
        long tOpen = System.currentTimeMillis();
        long bytesWritten = 0L;
        long tWrite = 0L;
        for (int rec = 0; rec < numRecs; ++rec) {
            skips[rec] = (int)(Math.random() * (double)recsize);
            raf.seek(raf.getFilePointer() + (long)skips[rec]);
            long tmpStart = System.currentTimeMillis();
            raf.write(sendBuffer, 0, recsize);
            bytesWritten += (long)recsize;
            tWrite += System.currentTimeMillis() - tmpStart;
        }
        if (bytesWritten != (long)(numRecs * recsize)) {
            System.out.println("not all data was written!");
            System.exit(1);
        }
        raf.getFD().sync();
        raf.seek(0L);
        long tFlush = System.currentTimeMillis();
        long tRead = 0L;
        byte[] readBuffer = new byte[recsize];
        for (int rec = 0; rec < numRecs; ++rec) {
            raf.seek(raf.getFilePointer() + (long)skips[rec]);
            long tmpStart = System.currentTimeMillis();
            int bytesRead = raf.read(readBuffer, 0, recsize);
            tRead += System.currentTimeMillis() - tmpStart;
            if (bytesRead != recsize) {
                System.out.println("PREMATURE END-OF-FILE AT " + rec * recsize);
                System.out.println("expected " + recsize + " bytes");
                System.out.println("got " + bytesRead + " bytes");
                System.exit(1);
            }
            for (int i = 0; i < recsize; ++i) {
                if (readBuffer[i] == (byte)(i % 26 + 65)) continue;
                System.out.println("INVALID CONTENT AT " + (rec * recsize + i));
                System.out.println("expected:  " + (byte)(i % 26 + 65));
                System.out.println("got     : " + readBuffer[i]);
                System.exit(1);
            }
        }
        File f = new File(path);
        f.delete();
        long tDelete = System.currentTimeMillis();
        double writeRate = (double)fsize / 1024.0 / ((double)tWrite / 1000.0);
        double readRate = (double)fsize / 1024.0 / ((double)tRead / 1000.0);
        System.out.format("fs: %8d   bs: %8d    write: %6d ms   %6.0f kb/s    read: %6d ms   %6.0f kb/s\n", fsize / 1024, recsize, tWrite, writeRate, tRead, readRate);
        return false;
    }

    private static void usage() {
        System.out.println("usage: torture [options]");
        System.out.println("  -p <path>   filename to use for measurements (default: /torture.dat)");
        System.out.println("  -r random only");
        System.out.println("  -h        show usage info");
    }
}

