/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.sandbox.tests;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.xtreemfs.common.clients.Client;
import org.xtreemfs.common.clients.File;
import org.xtreemfs.common.clients.RandomAccessFile;
import org.xtreemfs.common.clients.Volume;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.PBRPCServiceURL;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class rwrepl_test {
    public static final int WAIT_FOR_CLOSE = 90000;
    public static final int BLKSIZE = 131072;
    public static final String VOLNAME = "rwrtest";

    public static void main(String[] args) {
        try {
            ReusableBuffer data;
            long datacnt;
            PBRPCServiceURL dir = new PBRPCServiceURL(args[0], "oncrpc", 32638);
            int numReplicas = Integer.valueOf(args[1]);
            int fileSize = Integer.valueOf(args[2]) * 1024 * 1024;
            String mode = "rw";
            if (args.length > 3) {
                mode = args[3];
            }
            Logging.start(6, Logging.Category.all);
            TimeSync.initializeLocal(50);
            RPC.UserCredentials uc = RPC.UserCredentials.newBuilder().setUsername("test").addGroups("users").build();
            Client c = new Client(new InetSocketAddress[]{new InetSocketAddress(dir.getHost(), dir.getPort())}, 15000, 300000, null);
            c.start();
            try {
                GlobalTypes.StripingPolicy sp = GlobalTypes.StripingPolicy.newBuilder().setType(GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0).setWidth(1).setStripeSize(128).build();
                c.createVolume(VOLNAME, RPCAuthentication.authNone, uc, sp, GlobalTypes.AccessControlPolicyType.ACCESS_CONTROL_POLICY_POSIX, 511);
            }
            catch (Exception ex) {
                System.out.println("create volume failed: " + ex);
            }
            Volume v = c.getVolume(VOLNAME, uc);
            File f = v.getFile("data.rwrtest");
            try {
                f.delete();
            }
            catch (Exception ex) {
                System.out.println("create volume failed: " + ex);
            }
            f.createFile();
            if (!mode.contains("x")) {
                rwrepl_test.addReplicas(f, numReplicas, false);
            }
            RandomAccessFile io = f.open("rw", 292);
            System.out.println("replica: " + io.getCurrentReplica() + " = " + f.getReplica(io.getCurrentReplica()));
            if (mode.contains("w")) {
                for (datacnt = 0L; datacnt < (long)fileSize; datacnt += 131072L) {
                    data = BufferPool.allocate(131072);
                    rwrepl_test.fillData(data);
                    data.flip();
                    io.write(data);
                    System.out.print("w");
                    BufferPool.free(data);
                }
                System.out.println("");
                System.out.println("writing complete");
            }
            if (mode.contains("t")) {
                System.out.print("t");
                io.setLength(fileSize / 2);
                data = BufferPool.allocate(131072);
                rwrepl_test.fillData(data);
                data.flip();
                io.write(data);
                System.out.println("w");
                BufferPool.free(data);
            }
            io.close();
            Thread.sleep(90000L);
            if (mode.contains("x")) {
                rwrepl_test.addReplicas(f, numReplicas, false);
            }
            io = f.open("rw", 292);
            int nextRepl = (int)(Math.random() * (double)numReplicas) + 1;
            System.out.println("switch to replica " + nextRepl);
            io.forceReplica(nextRepl);
            System.out.println("replica: " + io.getCurrentReplica() + " = " + f.getReplica(io.getCurrentReplica()));
            if (mode.contains("r")) {
                for (datacnt = 0L; datacnt < (long)fileSize; datacnt += 131072L) {
                    ReusableBuffer data2 = BufferPool.allocate(131072);
                    io.read(data2);
                    System.out.print("r");
                    data2.flip();
                    if (!rwrepl_test.checkData(data2)) {
                        throw new Exception("invalid data read");
                    }
                    BufferPool.free(data2);
                }
                System.out.println("");
                System.out.println("read complete");
            }
            io.close();
            c.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void addReplicas(File f, int numReplicas, boolean quorum) throws Exception {
        System.out.println("adding " + numReplicas + " replicas");
        if (quorum) {
            f.setReplicaUpdatePolicy("WqRq");
        } else {
            f.setReplicaUpdatePolicy("WaR1");
        }
        for (int i = 0; i < numReplicas; ++i) {
            String[] suitableOSDs = f.getSuitableOSDs(1);
            System.out.println("suitable OSDs: " + suitableOSDs);
            if (suitableOSDs.length != 1) {
                throw new IOException("cannot add OSDs, no suitable OSD");
            }
            f.addReplica(1, suitableOSDs, 0);
        }
    }

    private static void fillData(ReusableBuffer data) {
        int cnt = 65;
        while (data.hasRemaining()) {
            int n = cnt;
            cnt = (byte)(cnt + 1);
            data.put((byte)n);
            if (cnt != 91) continue;
            cnt = 65;
        }
    }

    private static boolean checkData(ReusableBuffer data) {
        int cnt = 65;
        while (data.hasRemaining()) {
            int n = cnt;
            cnt = (byte)(cnt + 1);
            if (data.get() != n) {
                return false;
            }
            if (cnt != 91) continue;
            cnt = 65;
        }
        return true;
    }
}

