/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.xtreemfs.common.config.Config;
import org.xtreemfs.foundation.SSLOptions;

public class DefaultDirConfig
extends Config {
    public static final String DEFAULT_DIR_CONFIG = "/etc/xos/xtreemfs/default_dir";
    private static final int MAX_NUM_DIRS = 5;
    private boolean sslEnabled;
    protected String[] directoryServices = null;
    private String serviceCredsFile;
    private String serviceCredsPassphrase;
    private String serviceCredsContainer;
    private String trustedCertsFile;
    private String trustedCertsPassphrase;
    private String trustedCertsContainer;
    private String sslProtocolString;

    public DefaultDirConfig() throws IOException {
        super(DEFAULT_DIR_CONFIG);
        this.read();
    }

    public String[] getDirectoryServices() {
        return this.directoryServices;
    }

    public SSLOptions getSSLOptions() throws FileNotFoundException, IOException {
        if (this.sslEnabled) {
            return new SSLOptions(new FileInputStream(this.serviceCredsFile), this.serviceCredsPassphrase, this.serviceCredsContainer, new FileInputStream(this.trustedCertsFile), this.trustedCertsPassphrase, this.trustedCertsContainer, false, false, this.sslProtocolString, null);
        }
        return null;
    }

    private void read() throws IOException {
        String dirPort;
        String dirHost;
        ArrayList<String> dirServices = new ArrayList<String>();
        dirServices.add(this.readRequiredString("dir_service.host") + ":" + this.readRequiredString("dir_service.port"));
        for (int i = 1; i < 5 && !((dirHost = this.readOptionalString("dir_service" + (i + 1) + ".host", null)) == null | (dirPort = this.readOptionalString("dir_service" + (i + 1) + ".port", null)) == null); ++i) {
            dirServices.add(dirHost + ":" + dirPort);
        }
        this.directoryServices = dirServices.toArray(new String[dirServices.size()]);
        this.sslEnabled = this.readOptionalBoolean("ssl.enabled", false);
        if (this.sslEnabled) {
            this.serviceCredsFile = this.readRequiredString("ssl.service_creds");
            this.serviceCredsPassphrase = this.readRequiredString("ssl.service_creds.pw");
            this.serviceCredsContainer = this.readRequiredString("ssl.service_creds.container");
            this.trustedCertsFile = this.readRequiredString("ssl.trusted_certs");
            this.trustedCertsPassphrase = this.readRequiredString("ssl.trusted_certs.pw");
            this.trustedCertsContainer = this.readRequiredString("ssl.trusted_certs.container");
            this.sslProtocolString = this.readOptionalString("ssl.protocol", null);
        }
    }
}

