/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.xtreemfs.foundation.util.CLIParser;

public class utils {
    public static final String OPTION_USER_CREDS_FILE = "c";
    public static final String OPTION_USER_CREDS_PASS = "cpass";
    public static final String OPTION_TRUSTSTORE_FILE = "t";
    public static final String OPTION_TRUSTSTORE_PASS = "tpass";
    public static final String OPTION_SSL_PROTOCOL = "-ssl-protocol";
    public static final String OPTION_HELP = "h";
    public static final String OPTION_HELP_LONG = "-help";
    public static final String OPTION_ADMIN_PASS = "-admin_password";

    public static Map<String, String> getxattrs(String filename) throws IOException, InterruptedException {
        String nextLine;
        File f = new File(filename);
        Process p = Runtime.getRuntime().exec(new String[]{"getfattr", "-m", "xtreemfs.*", "-d", f.getAbsolutePath()});
        p.waitFor();
        if (p.exitValue() != 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        br.readLine();
        while ((nextLine = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(nextLine, "=");
            if (!st.hasMoreElements()) continue;
            String key = st.nextToken();
            String value = st.nextToken();
            value = value.substring(1, value.length() - 1);
            value = value.replace("\\\"", "\"");
            result.put(key, value);
        }
        return result;
    }

    public static String getxattr(String filename, String attrname) throws IOException, InterruptedException {
        File f = new File(filename);
        Process p = Runtime.getRuntime().exec(new String[]{"getfattr", "--only-values", "-n", attrname, f.getAbsolutePath()});
        p.waitFor();
        if (p.exitValue() != 0) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String target = br.readLine();
        return target;
    }

    public static void setxattr(String filename, String attrname, String attrvalue) throws IOException, InterruptedException {
        File f = new File(filename);
        Process p = Runtime.getRuntime().exec(new String[]{"setfattr", "-n", attrname, "-v", attrvalue, f.getAbsolutePath()});
        p.waitFor();
        if (p.exitValue() != 0) {
            String line;
            String err = "a problem occurred when setting '" + attrname + "'\n";
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = in.readLine()) != null) {
                err = err + line + "\n";
            }
            throw new IOException(err);
        }
    }

    public static String expandPath(String path) {
        File f = new File(path);
        return f.getAbsolutePath();
    }

    public static boolean isXtreemFSDir(String path) throws IOException, InterruptedException {
        String url = utils.getxattr(path, "xtreemfs.url");
        return url != null;
    }

    public static String findXtreemFSRootDir(String path) throws IOException, InterruptedException {
        String url = utils.getxattr(path = utils.expandPath(path), "xtreemfs.url");
        if (url == null) {
            return null;
        }
        String parentDir = path.substring(0, path.lastIndexOf(File.separator));
        String xtfsParent = utils.findXtreemFSRootDir(parentDir);
        if (xtfsParent == null) {
            return path;
        }
        return xtfsParent;
    }

    public static Map<String, CLIParser.CliOption> getDefaultAdminToolOptions(boolean adminPass) {
        HashMap<String, CLIParser.CliOption> options = new HashMap<String, CLIParser.CliOption>();
        options.put(OPTION_USER_CREDS_FILE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "a PKCS#12 file containing user credentials (SSL/GridSSL only)", "<creds_file>"));
        options.put(OPTION_USER_CREDS_PASS, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "a pass phrase to decrypt the the user credentials file (SSL/GridSSL only).  Set to '-' to prompt for the passphrase.", "<creds_passphrase>"));
        options.put(OPTION_TRUSTSTORE_FILE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "a PKCS#12 file containing a set of certificates from trusted CAs (SSL/GridSSL only)", "<trusted_CAs>"));
        options.put(OPTION_TRUSTSTORE_PASS, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "a pass phrase to decrypt the trusted CAs file (SSL/GridSSL only).  Set to '-' to prompt for the passphrase.", "<trusted_passphrase>"));
        options.put(OPTION_SSL_PROTOCOL, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "SSL/TLS version to use: sslv3, ssltls, tlsv1, tlsv11, tlsv12. 'ssltls' (default) accepts all versions, the others accept only the exact version they name. 'tlsv12' is available in JDK 7+ only. 'tlsv11' comes with JDK 6 or 7, depending on the vendor.", "<ssl_protocol>"));
        options.put(OPTION_HELP, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "show usage information", ""));
        options.put(OPTION_HELP_LONG, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "show usage information", ""));
        if (adminPass) {
            options.put(OPTION_ADMIN_PASS, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "administrator password to authorize operation", "<passphrase>"));
        }
        return options;
    }

    public static void printOptions(Map<String, CLIParser.CliOption> options) {
        TreeMap<String, CLIParser.CliOption> optionsMap = new TreeMap<String, CLIParser.CliOption>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.startsWith("-") && !o2.startsWith("-")) {
                    return 1;
                }
                if (!o1.startsWith("-") && o2.startsWith("-")) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
        optionsMap.putAll(options);
        int maxLength = 0;
        for (Map.Entry entry : optionsMap.entrySet()) {
            int len = ((String)entry.getKey()).length() + ((CLIParser.CliOption)entry.getValue()).usageParams.length();
            if (len <= maxLength) continue;
            maxLength = len;
        }
        Iterator it = optionsMap.entrySet().iterator();
        String previous = "";
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (((String)next.getKey()).startsWith("-") && !previous.startsWith("-")) {
                System.out.println();
            }
            StringBuffer line = new StringBuffer();
            line.append("      -" + (String)next.getKey() + " " + ((CLIParser.CliOption)next.getValue()).usageParams);
            for (int i = 0; i < maxLength - ((String)next.getKey()).length() - ((CLIParser.CliOption)next.getValue()).usageParams.length() + 4; ++i) {
                line.append(" ");
            }
            line.append(((CLIParser.CliOption)next.getValue()).usageText);
            System.out.println(line.toString());
            previous = (String)next.getKey();
        }
    }
}

