/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils.xtfs_benchmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.foundation.util.CLIParser;
import org.xtreemfs.utils.utils;

class CLIOptions {
    private Map<String, CLIParser.CliOption> options = utils.getDefaultAdminToolOptions(true);
    private List<String> arguments;
    private BenchmarkConfig.ConfigBuilder builder = BenchmarkConfig.newBuilder();
    private static final String DIR_ADDRESSES = "-dir-addresses";
    private static final String OSD_SELECTION_POLICIES = "-osd-selection-policies";
    private static final String OSD_SELECTION_UUIDS = "-osd-selection-uuids";
    private static final String USERNAME = "-user";
    private static final String GROUPNAME = "-group";
    private static final String SEQ_UNALIGNED_WRITE;
    private static final String SEQ_WRITE;
    private static final String SEQ_READ;
    private static final String RAND_WRITE;
    private static final String RAND_READ;
    private static final String FILEBASED_WRITE;
    private static final String FILEBASED_READ;
    private static final String THREADS;
    private static final String REPETITIONS;
    private static final String CHUNK_SIZE;
    private static final String REPLICATION_POLICY;
    private static final String REPLICATION_FACTOR;
    private static final String STRIPE_SIZE;
    private static final String STRIPE_WITDH;
    private static final String SIZE_SEQ;
    private static final String SIZE_RAND;
    private static final String SIZE_BASEFILE;
    private static final String SIZE_FILES;
    private static final String NO_CLEANUP;
    private static final String NO_CLEANUP_VOLUMES;
    private static final String NO_CLEANUP_BASEFILE;
    private static final String OSD_CLEANUP;
    private static final String CONFIG;

    CLIOptions() {
        this.arguments = new ArrayList<String>(20);
    }

    void parseCLIOptions(String[] args) {
        this.initOptions();
        CLIParser.parseCLI(args, this.options, this.arguments);
    }

    BenchmarkConfig buildParamsFromCLIOptions() throws Exception {
        this.setBasefileSize();
        this.setFileSize();
        this.setDirAddresses();
        this.setOsdSelectionPolicies();
        this.setOsdSelectionByUuids();
        this.setUsername();
        this.setGroup();
        this.setOSDPassword();
        this.setSSLOptions();
        this.setChunkSize();
        this.setReplicationPolicy();
        this.setReplicationFactor();
        this.setStripeSize();
        this.setStripeWidth();
        this.setNoCleanup();
        this.setNoCleanupOfVolumes();
        this.setNoCleanupOfBasefile();
        this.setOsdCleanup();
        this.setConfig();
        return this.builder.build();
    }

    private void initOptions() {
        this.options.put(DIR_ADDRESSES, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "directory service(s) to use (e.g. 'localhost:32638'). If no URI is specified, URI and security settings are taken from '/etc/xos/xtreemfs/default_dir' or from " + CONFIG + ". Also accepts a list of comma-separated DIR services.", "<uri>"));
        this.options.put(OSD_SELECTION_POLICIES, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "OSD selection policies to use when creating or opening volumes. default: 1000,3002", "<osd selection policies>"));
        this.options.put(OSD_SELECTION_UUIDS, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "Set the UUID-based filter policy (ID 1002) as OSD selection policy and set the uuids to be used by the policy (applied when creating or opening volumes). It is not allowed to use this option with the -" + OSD_SELECTION_POLICIES + " option. Default: No selection by UUIDs", "<osd uuids to use>"));
        this.options.put(USERNAME, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "username to use", "<username>"));
        this.options.put(GROUPNAME, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "name of group to use", "<group name>"));
        this.options.put(CONFIG, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "Config file to use. Mainly connection information like dir address and ssl settings are used. Explicit settings via commandline take precedence over settings from the config file", "<path to config file>"));
        this.options.put(SEQ_WRITE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "sequential write benchmark", ""));
        this.options.put(SEQ_UNALIGNED_WRITE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "unaligned sequential write benchmark", ""));
        this.options.put(SEQ_READ, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "sequential read benchmark", ""));
        this.options.put(RAND_WRITE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "random write benchmark", ""));
        this.options.put(RAND_READ, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "random read benchmark", ""));
        this.options.put(FILEBASED_WRITE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "random filebased write benchmark", ""));
        this.options.put(FILEBASED_READ, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "random filebased read benchmark", ""));
        this.options.put(THREADS, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "number of benchmarks to be started in parallel. default: 1", "<number>"));
        this.options.put(REPETITIONS, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "number of repetitions of a benchmarks. default: 1", "<number>"));
        this.options.put(CHUNK_SIZE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "Chunk size of reads/writes in benchmark in [B|K|M|G] (no modifier assumes bytes). default: 128K", "<chunkSize>"));
        this.options.put(REPLICATION_POLICY, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "Replication policy to use for new volumes. default: none", "<replication policy>"));
        this.options.put(REPLICATION_FACTOR, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "Replication factor to use for new volumes. default: 3", "<replication factor>"));
        this.options.put(STRIPE_SIZE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "stripeSize in [B|K|M|G] (no modifier assumes bytes). default: 128K", "<stripeSize>"));
        this.options.put(STRIPE_WITDH, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "stripe width. default: 1", "<stripe width>"));
        this.options.put(SIZE_SEQ, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "size for sequential benchmarks in [B|K|M|G] (no modifier assumes bytes)", "<size>"));
        this.options.put(SIZE_RAND, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "size for random benchmarks in [B|K|M|G] (no modifier assumes bytes)", "<size>"));
        this.options.put(SIZE_BASEFILE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "size of the basefile for random benchmarks in [B|K|M|G] (no modifier assumes bytes)", "<size>"));
        this.options.put(SIZE_FILES, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "size of the files for filebased benchmarks in [B|K|M|G] (no modifier assumes bytes). The filesize must be <= 2^31-1", "<size>"));
        String noCleanupDescription = "do not delete created volumes and files. Volumes and files need to be removed manually. Volumes can be removed using rmfs.xtreemfs. Files can be removed by mounting the according volume with mount.xtreemfs and deleting the files with rm";
        this.options.put(NO_CLEANUP, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, noCleanupDescription, ""));
        this.options.put(NO_CLEANUP_VOLUMES, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "do not delete created volumes. Created volumes neet to be removed manually using rmfs.xtreemfs", ""));
        String noCleanupBasefileDescription = "do not delete created basefile (only works with --no-cleanup or --no-cleanup-volumes. Created Files and volumes need to be removed manually";
        this.options.put(NO_CLEANUP_BASEFILE, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, noCleanupBasefileDescription, ""));
        this.options.put(OSD_CLEANUP, new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "Run OSD cleanup after the benchmarks", ""));
    }

    boolean usageIsSet() {
        return this.options.get((Object)"h").switchValue != false || this.options.get((Object)"-help").switchValue != false;
    }

    void displayUsage() {
        System.out.println("\nusage: xtfs_benchmark [options] volume1 volume2 ... \n");
        System.out.println("The number of volumes must be in accordance with the number of benchmarks run in parallel (see -p).");
        System.out.println("All sizes can be modified with multiplication modifiers, where K means KiB, M means MiB and G means GiB. \nIf no modifier is given, sizes are assumed to be in bytes.");
        System.out.println();
        System.out.println("  options:");
        utils.printOptions(this.options);
        System.out.println();
        System.out.println("example: xtfs_benchmark -sw -sr -n 3 -ssize 3G volume1 volume2 volume3");
        System.out.println("\t\t starts a sequential write and read benchmark of 3 GiB with 3 benchmarks in parallel on volume1, volume2 and volume3\n");
    }

    private void setBasefileSize() {
        String optionValue = this.options.get((Object)CLIOptions.SIZE_BASEFILE).stringValue;
        if (null != optionValue) {
            this.builder.setBasefileSizeInBytes(this.parseSizeWithModifierToBytes(optionValue));
        }
    }

    private void setFileSize() {
        String optionValue = this.options.get((Object)CLIOptions.SIZE_FILES).stringValue;
        if (null != optionValue) {
            long sizeInBytes = this.parseSizeWithModifierToBytes(optionValue);
            if (sizeInBytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Filesize for filebased random IO Benchmarks must be <= 23^31-1");
            }
            this.builder.setFilesize((int)sizeInBytes);
        }
    }

    private void setDirAddresses() {
        String dirAddresses = this.options.get((Object)CLIOptions.DIR_ADDRESSES).stringValue;
        if (null != dirAddresses) {
            this.builder.setDirAddresses(dirAddresses.split(","));
        }
    }

    private void setOsdSelectionPolicies() {
        String osdSelectionPolicies = this.options.get((Object)CLIOptions.OSD_SELECTION_POLICIES).stringValue;
        if (null != osdSelectionPolicies) {
            this.builder.setOsdSelectionPolicies(osdSelectionPolicies);
        }
    }

    private void setOsdSelectionByUuids() {
        String osdSelectionUuids = this.options.get((Object)CLIOptions.OSD_SELECTION_UUIDS).stringValue;
        if (null != osdSelectionUuids) {
            this.builder.setSelectOsdsByUuid(osdSelectionUuids);
        }
    }

    private void setUsername() {
        String userName = this.options.get((Object)CLIOptions.USERNAME).stringValue;
        if (null != userName) {
            this.builder.setUserName(userName);
        }
    }

    private void setGroup() {
        String groupName = this.options.get((Object)CLIOptions.GROUPNAME).stringValue;
        if (null != groupName) {
            this.builder.setGroup(groupName);
        } else {
            String userName = this.options.get((Object)CLIOptions.USERNAME).stringValue;
            if (null != userName) {
                this.builder.setGroup(userName);
            }
        }
    }

    private void setOSDPassword() {
        String osdPassword = this.options.get((Object)"-admin_password").stringValue;
        if (null != osdPassword) {
            this.builder.setAdminPassword(osdPassword);
        }
    }

    private void setSSLOptions() throws IOException {
        String[] dirURLs;
        String[] stringArray = dirURLs = this.options.get((Object)CLIOptions.DIR_ADDRESSES).stringValue != null ? this.options.get((Object)CLIOptions.DIR_ADDRESSES).stringValue.split(",") : null;
        if (dirURLs != null) {
            boolean gridSSL = false;
            String dirURL = dirURLs[0];
            if (dirURL.contains("pbrpcs://") || dirURL.contains("pbrpcg://")) {
                String serviceCredsFile = this.options.get((Object)"c").stringValue;
                String serviceCredsPass = this.options.get((Object)"cpass").stringValue;
                String trustedCAsFile = this.options.get((Object)"t").stringValue;
                String trustedCAsPass = this.options.get((Object)"tpass").stringValue;
                if (dirURL.contains("pbrpcg://")) {
                    gridSSL = true;
                }
                if (null == serviceCredsFile) {
                    throw new IllegalArgumentException("SSL requires '-c' parameter to be specified");
                }
                if (trustedCAsFile == null) {
                    throw new IllegalArgumentException("SSL requires '-t' parameter to be specified");
                }
                this.builder.setSslOptions(true, gridSSL, serviceCredsFile, serviceCredsPass, trustedCAsFile, trustedCAsPass);
            }
        }
    }

    private void setReplicationPolicy() {
        String replicationPolicy = this.options.get((Object)CLIOptions.REPLICATION_POLICY).stringValue;
        if (null != replicationPolicy) {
            assert ("".equals(replicationPolicy) || "WqRq".equals(replicationPolicy) || "WaR1".equals(replicationPolicy)) : "Unknown replication policy: " + replicationPolicy;
            this.builder.setReplicationPolicy(replicationPolicy);
        }
    }

    private void setReplicationFactor() {
        String replicationFactor = this.options.get((Object)CLIOptions.REPLICATION_FACTOR).stringValue;
        if (null != replicationFactor) {
            this.builder.setReplicationFactor(Integer.parseInt(replicationFactor));
        }
    }

    private void setChunkSize() {
        String chunkSize = this.options.get((Object)CLIOptions.CHUNK_SIZE).stringValue;
        if (null != chunkSize) {
            long chunkSizeInBytes = this.parseSizeWithModifierToBytes(chunkSize);
            assert (chunkSizeInBytes <= Integer.MAX_VALUE) : "ChunkSize must be less equal than Integer.MAX_VALUE";
            this.builder.setChunkSizeInBytes((int)chunkSizeInBytes);
        }
    }

    private void setStripeSize() {
        String stripeSize = this.options.get((Object)CLIOptions.STRIPE_SIZE).stringValue;
        if (null != stripeSize) {
            long stripeSizeInBytes = this.parseSizeWithModifierToBytes(stripeSize);
            assert (stripeSizeInBytes <= Integer.MAX_VALUE) : "StripeSize must be less equal than Integer.MAX_VALUE";
            this.builder.setStripeSizeInBytes((int)stripeSizeInBytes);
        }
    }

    private void setStripeWidth() {
        String stripeWidth = this.options.get((Object)CLIOptions.STRIPE_WITDH).stringValue;
        if (null != stripeWidth) {
            this.builder.setStripeWidth(Integer.parseInt(stripeWidth));
        }
    }

    private void setNoCleanup() {
        boolean switchValue = this.options.get((Object)CLIOptions.NO_CLEANUP).switchValue;
        if (switchValue) {
            this.builder.setNoCleanup();
        }
    }

    private void setNoCleanupOfVolumes() {
        boolean switchValue = this.options.get((Object)CLIOptions.NO_CLEANUP_VOLUMES).switchValue;
        if (switchValue) {
            this.builder.setNoCleanupVolumes();
        }
    }

    private void setNoCleanupOfBasefile() {
        boolean switchValue = this.options.get((Object)CLIOptions.NO_CLEANUP_BASEFILE).switchValue;
        if (switchValue) {
            this.builder.setNoCleanupBasefile();
        }
    }

    private void setOsdCleanup() {
        boolean switchValue = this.options.get((Object)CLIOptions.OSD_CLEANUP).switchValue;
        if (switchValue) {
            this.builder.setOsdCleanup();
        }
    }

    private void setConfig() throws IOException {
        String configPath = this.options.get((Object)CLIOptions.CONFIG).stringValue;
        if (null != configPath) {
            ServiceConfig config = new ServiceConfig(configPath);
            config.readParameters(BenchmarkConfig.getBenchmarkParameter());
            config.setDefaults(BenchmarkConfig.getBenchmarkParameter());
            this.builder.setParent(config);
        }
    }

    int getNumberOfThreads() {
        String optionValue = this.options.get((Object)CLIOptions.THREADS).stringValue;
        if (null != optionValue) {
            return Integer.valueOf(optionValue);
        }
        return 1;
    }

    long getSequentialSize() {
        String optionValue = this.options.get((Object)CLIOptions.SIZE_SEQ).stringValue;
        if (null != optionValue) {
            return this.parseSizeWithModifierToBytes(optionValue);
        }
        return 0xA00000L;
    }

    long getRandomSize() {
        String optionValue = this.options.get((Object)CLIOptions.SIZE_RAND).stringValue;
        if (null != optionValue) {
            return this.parseSizeWithModifierToBytes(optionValue);
        }
        return 0xA00000L;
    }

    int getNumberOfRepetitions() {
        String optionValue = this.options.get((Object)CLIOptions.REPETITIONS).stringValue;
        if (null != optionValue) {
            return Integer.valueOf(optionValue);
        }
        return 1;
    }

    boolean sequentialWriteBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.SEQ_WRITE).switchValue;
    }

    boolean unalignedSequentialWriteBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.SEQ_UNALIGNED_WRITE).switchValue;
    }

    boolean sequentialReadBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.SEQ_READ).switchValue;
    }

    boolean randomReadBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.RAND_READ).switchValue;
    }

    boolean randomWriteBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.RAND_WRITE).switchValue;
    }

    boolean randomFilebasedWriteBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.FILEBASED_WRITE).switchValue;
    }

    boolean randomFilebasedReadBenchmarkIsSet() {
        return this.options.get((Object)CLIOptions.FILEBASED_READ).switchValue;
    }

    private long parseSizeWithModifierToBytes(String size) {
        long sizeInBytes;
        if (!(size = size.toUpperCase()).matches("[0-9]+[BKMG]?")) {
            throw new IllegalArgumentException("Wrong format for size.");
        }
        if (size.matches("[0-9]+")) {
            sizeInBytes = Long.valueOf(size);
        } else {
            char suffix = size.charAt(size.length() - 1);
            long numbers = Long.valueOf(size.substring(0, size.length() - 1));
            switch (suffix) {
                case 'B': {
                    sizeInBytes = numbers;
                    break;
                }
                case 'K': {
                    sizeInBytes = numbers * 1024L;
                    break;
                }
                case 'M': {
                    sizeInBytes = numbers * 0x100000L;
                    break;
                }
                case 'G': {
                    sizeInBytes = numbers * 0x40000000L;
                    break;
                }
                default: {
                    sizeInBytes = 0L;
                }
            }
        }
        return sizeInBytes;
    }

    List<String> getArguments() {
        return this.arguments;
    }

    static {
        SEQ_WRITE = "sw";
        SEQ_READ = "sr";
        SEQ_UNALIGNED_WRITE = "usw";
        RAND_WRITE = "rw";
        RAND_READ = "rr";
        FILEBASED_WRITE = "fw";
        FILEBASED_READ = "fr";
        THREADS = "n";
        REPETITIONS = "r";
        CHUNK_SIZE = "-chunk-size";
        REPLICATION_POLICY = "-replication-policy";
        REPLICATION_FACTOR = "-replication-factor";
        STRIPE_SIZE = "-stripe-size";
        STRIPE_WITDH = "-stripe-width";
        SIZE_SEQ = "ssize";
        SIZE_RAND = "rsize";
        SIZE_BASEFILE = "-basefile-size";
        SIZE_FILES = "-file-size";
        NO_CLEANUP = "-no-cleanup";
        NO_CLEANUP_VOLUMES = "-no-cleanup-volumes";
        NO_CLEANUP_BASEFILE = "-no-cleanup-basefile";
        OSD_CLEANUP = "-osd-cleanup";
        CONFIG = "-config";
    }
}

