/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils.xtfs_benchmark;

import java.util.ArrayList;
import org.xtreemfs.common.benchmark.BenchmarkConfig;
import org.xtreemfs.common.benchmark.BenchmarkResult;
import org.xtreemfs.common.benchmark.Controller;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.utils.xtfs_benchmark.CLIOptions;
import org.xtreemfs.utils.xtfs_benchmark.UncaughtExceptionHandlerBenchmark;

public class xtfs_benchmark {
    private static Controller controller;
    private static CLIOptions cliOptions;

    public static void main(String[] args) throws Exception {
        Logging.start(6, Logging.Category.tool);
        Logging.redirect(System.err);
        cliOptions.parseCLIOptions(args);
        if (cliOptions.usageIsSet()) {
            cliOptions.displayUsage();
            return;
        }
        BenchmarkConfig config = cliOptions.buildParamsFromCLIOptions();
        controller = new Controller(config);
        controller.tryConnection();
        if (cliOptions.getArguments().size() > 0) {
            controller.setupVolumes(cliOptions.getArguments().toArray(new String[cliOptions.getArguments().size()]));
        } else {
            controller.setupDefaultVolumes(cliOptions.getNumberOfThreads());
        }
        ArrayList<BenchmarkResult> results = xtfs_benchmark.repeatBenchmark();
        xtfs_benchmark.printResults(results);
        Thread.sleep(5L);
        xtfs_benchmark.printResultsCSV(results);
        controller.teardown();
    }

    private static ArrayList<BenchmarkResult> repeatBenchmark() throws Exception {
        int numberOfRepetitions = cliOptions.getNumberOfRepetitions();
        ArrayList<BenchmarkResult> results = new ArrayList<BenchmarkResult>(numberOfRepetitions);
        for (int i = 0; i < numberOfRepetitions; ++i) {
            ArrayList<BenchmarkResult> result = xtfs_benchmark.runBenchmarks();
            results.addAll(result);
        }
        return results;
    }

    private static ArrayList<BenchmarkResult> runBenchmarks() throws Exception {
        ArrayList<BenchmarkResult> result;
        ArrayList<BenchmarkResult> results = new ArrayList<BenchmarkResult>();
        if (cliOptions.sequentialWriteBenchmarkIsSet()) {
            result = controller.startSequentialWriteBenchmark(cliOptions.getSequentialSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        if (cliOptions.unalignedSequentialWriteBenchmarkIsSet()) {
            result = controller.startUnalignedSequentialWriteBenchmark(cliOptions.getSequentialSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        if (cliOptions.sequentialReadBenchmarkIsSet()) {
            result = controller.startSequentialReadBenchmark(cliOptions.getSequentialSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        if (cliOptions.randomWriteBenchmarkIsSet()) {
            result = controller.startRandomWriteBenchmark(cliOptions.getRandomSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        if (cliOptions.randomReadBenchmarkIsSet()) {
            result = controller.startRandomReadBenchmark(cliOptions.getRandomSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        if (cliOptions.randomFilebasedWriteBenchmarkIsSet()) {
            result = controller.startFilebasedWriteBenchmark(cliOptions.getRandomSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        if (cliOptions.randomFilebasedReadBenchmarkIsSet()) {
            result = controller.startFilebasedReadBenchmark(cliOptions.getRandomSize(), cliOptions.getNumberOfThreads());
            results.addAll(result);
        }
        return results;
    }

    private static void printResultsCSV(ArrayList<BenchmarkResult> results) {
        System.out.println("Type;NumberOfParallelThreads;TimeInSec;MiB/Sec;DataWrittenInBytes;ByteCount");
        for (BenchmarkResult res : results) {
            System.out.println(xtfs_benchmark.resultToCSV(res));
        }
    }

    private static void printResults(ArrayList<BenchmarkResult> results) {
        for (BenchmarkResult res : results) {
            System.err.println(xtfs_benchmark.resultToString(res));
        }
    }

    private static String resultToString(BenchmarkResult result) {
        String dataWritten;
        String string = dataWritten = result.getRequestedSize() >= 0x40000000L ? result.getRequestedSize() / 0x40000000L + " GiB [" : result.getRequestedSize() / 0x100000L + " MiB [";
        String readersOrWriters = result.isWriteBenchmark() ? "\tNumber of Writers: " + result.getNumberOfReadersOrWriters() + "\n" : (result.isReadBenchmark() ? "\tNumber of Readers: " + result.getNumberOfReadersOrWriters() + "\n" : "\tNumber of Readers/Writers: " + result.getNumberOfReadersOrWriters() + "\n");
        return "{\n\tBenchmarkType: " + (Object)((Object)result.getBenchmarkType()) + "\n" + readersOrWriters + "\tTime: " + result.getTimeInSec() + " Sec\n" + "\tSpeed: " + xtfs_benchmark.getSpeedInMiBPerSec(result.getActualSize(), result.getTimeInSec()) + " MiB/s\n" + "\tData written: " + dataWritten + result.getRequestedSize() + " Bytes]\n" + "\tByteCount: " + result.getActualSize() + " Bytes\n" + "}";
    }

    private static String resultToCSV(BenchmarkResult result) {
        return (Object)((Object)result.getBenchmarkType()) + ";" + result.getNumberOfReadersOrWriters() + ";" + result.getTimeInSec() + ";" + xtfs_benchmark.getSpeedInMiBPerSec(result.getActualSize(), result.getTimeInSec()) + ";" + result.getRequestedSize() + ";" + result.getActualSize();
    }

    private static double getSpeedInMiBPerSec(long size, double time) {
        return xtfs_benchmark.round((double)size / 1048576.0 / time, 2);
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    static {
        cliOptions = new CLIOptions();
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandlerBenchmark());
    }
}

