/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.ClientFactory;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.util.CLIParser;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.utils.DefaultDirConfig;
import org.xtreemfs.utils.utils;

public class xtfs_chstatus {
    public static void main(String[] args) {
        Logging.start(4, new Logging.Category[0]);
        Map<String, CLIParser.CliOption> options = utils.getDefaultAdminToolOptions(false);
        ArrayList<String> arguments = new ArrayList<String>(1);
        CLIParser.CliOption oDir = new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "directory service to use (e.g. 'pbrpc://localhost:32638'). If no URI is specified, URI and security settings are taken from '/etc/xos/xtreemfs/default_dir'", "<uri>");
        oDir.urlDefaultPort = GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber();
        oDir.urlDefaultProtocol = "pbrpc";
        options.put("dir", oDir);
        CLIParser.parseCLI(args, options, arguments);
        if (options.get((Object)"h").switchValue.booleanValue() || options.get((Object)"-help").switchValue.booleanValue()) {
            xtfs_chstatus.usage(options);
            return;
        }
        if (arguments.size() > 2 || arguments.size() < 1) {
            xtfs_chstatus.error("invalid number of arguments", options);
        }
        String[] dirURLs = options.get((Object)"dir").stringValue != null ? options.get((Object)"dir").stringValue.split(",") : null;
        SSLOptions sslOptions = null;
        String[] dirAddrs = null;
        if (dirURLs != null) {
            int i = 0;
            boolean gridSSL = false;
            dirAddrs = new String[dirURLs.length];
            for (String dirURL : dirURLs) {
                if (dirURL.contains("pbrpcs://") || dirURL.contains("pbrpcg://") && sslOptions == null) {
                    String serviceCredsFile = options.get((Object)"c").stringValue;
                    String serviceCredsPass = options.get((Object)"cpass").stringValue;
                    if (serviceCredsPass != null && serviceCredsPass.equals("-")) {
                        serviceCredsPass = new String(System.console().readPassword("Enter credentials password: ", new Object[0]));
                    }
                    String trustedCAsFile = options.get((Object)"t").stringValue;
                    String trustedCAsPass = options.get((Object)"tpass").stringValue;
                    if (trustedCAsPass != null && trustedCAsPass.equals("-")) {
                        trustedCAsPass = new String(System.console().readPassword("Enter credentials password: ", new Object[0]));
                    }
                    String sslProtocolString = options.get((Object)"-ssl-protocol").stringValue;
                    if (dirURL.contains("pbrpcg://")) {
                        gridSSL = true;
                    }
                    if (serviceCredsFile == null) {
                        System.out.println("SSL requires '-c' parameter to be specified");
                        xtfs_chstatus.usage(options);
                        System.exit(1);
                    } else if (trustedCAsFile == null) {
                        System.out.println("SSL requires '-t' parameter to be specified");
                        xtfs_chstatus.usage(options);
                        System.exit(1);
                    }
                    try {
                        sslOptions = new SSLOptions(new FileInputStream(serviceCredsFile), serviceCredsPass, "PKCS12", new FileInputStream(trustedCAsFile), trustedCAsPass, "JKS", false, gridSSL, sslProtocolString, null);
                    }
                    catch (Exception e) {
                        System.err.println("unable to get SSL options, because:" + e.getMessage());
                        System.exit(1);
                    }
                }
                if (dirURL.contains("://")) {
                    String[] tmp = dirURL.split("://");
                    dirAddrs[i++] = tmp[1].replace("/", "");
                    continue;
                }
                dirAddrs[i++] = dirURL.replace("/", "");
            }
        }
        if (dirURLs == null) {
            try {
                DefaultDirConfig cfg = new DefaultDirConfig();
                sslOptions = cfg.getSSLOptions();
                dirAddrs = cfg.getDirectoryServices();
            }
            catch (Exception e) {
                System.err.println("unable to get SSL options, because: " + e.getMessage());
                System.exit(1);
            }
        }
        String uuid = (String)arguments.get(0);
        String newStatusName = arguments.size() == 2 ? (String)arguments.get(1) : null;
        AdminClient client = ClientFactory.createAdminClient(dirAddrs, RPCAuthentication.userService, sslOptions, new Options());
        try {
            client.start();
        }
        catch (Exception e) {
            System.err.println("unable to start client, because:");
        }
        DIR.ServiceStatus oldStatus = null;
        try {
            oldStatus = client.getOSDServiceStatus(uuid);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.out.print("current status: ");
        switch (oldStatus) {
            case SERVICE_STATUS_AVAIL: {
                System.out.println("online");
                break;
            }
            case SERVICE_STATUS_TO_BE_REMOVED: {
                System.out.println("locked (read-only)");
                break;
            }
            case SERVICE_STATUS_REMOVED: {
                System.out.println("removed");
            }
        }
        if (newStatusName != null) {
            DIR.ServiceStatus newStatus = null;
            if (newStatusName.equalsIgnoreCase("online")) {
                newStatus = DIR.ServiceStatus.SERVICE_STATUS_AVAIL;
            } else if (newStatusName.equalsIgnoreCase("locked")) {
                newStatus = DIR.ServiceStatus.SERVICE_STATUS_TO_BE_REMOVED;
                newStatusName = "locked (read-only)";
            } else if (newStatusName.equalsIgnoreCase("removed")) {
                newStatus = DIR.ServiceStatus.SERVICE_STATUS_REMOVED;
            } else {
                System.out.println("unknown status name: " + newStatusName + ". Must be 'online', ' locked' or 'removed'");
                System.exit(1);
            }
            try {
                client.setOSDServiceStatus(uuid, newStatus);
            }
            catch (IOException e) {
                System.err.println("unable to set new status at DIR, because " + e.getMessage());
                System.exit(1);
            }
            System.out.println("status changed to: " + newStatusName);
        }
        client.shutdown();
        System.exit(0);
    }

    private static void error(String message, Map<String, CLIParser.CliOption> options) {
        System.err.println(message);
        System.out.println();
        xtfs_chstatus.usage(options);
        System.exit(1);
    }

    private static void usage(Map<String, CLIParser.CliOption> options) {
        System.out.println("usage: xtfs_chstatus [options] <OSD UUID> [online|locked|removed]");
        System.out.println("<OSD UUID> the registered UUID for which the status is supposed to be changed");
        System.out.println(" online - Marks the OSD as online.");
        System.out.println(" locked - Marks the OSD as locked (locked OSDs will not be assigned to new files).");
        System.out.println("removed - Marks the OSD as no longer available. Replicas on this OSD can be replaced by xtfs_scrub.");
        System.out.println();
        System.out.println("Options:");
        utils.printOptions(options);
    }
}

