/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Map;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.ClientFactory;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.CLIParser;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.utils.DefaultDirConfig;
import org.xtreemfs.utils.utils;

public class xtfs_cleanup_osd {
    private static String password;
    private static AdminClient client;

    public static void main(String[] args) {
        Logging.start(4, new Logging.Category[0]);
        Map<String, CLIParser.CliOption> options = utils.getDefaultAdminToolOptions(true);
        ArrayList<String> arguments = new ArrayList<String>(1);
        options.put("r", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "restore zombies found on the OSD", ""));
        options.put("e", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "erase potential zombies", ""));
        options.put("delete_volumes", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "!dangerous! deletes volumes that might be dead", ""));
        CLIParser.CliOption oDelMeta = new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.NUMBER, "delete metadata of zombie files, if the XLocSet has not been updated during the last <timeout> seconds (default: 600)", "<timeout>");
        options.put("metadata_timeout", oDelMeta);
        options.put("metadata_keep", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "keep metadata (by default metadata is deleted after <timeout> seconds)", ""));
        options.put("i", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "interactive mode", ""));
        options.put("stop", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "suspends the currently running cleanup process", ""));
        options.put("wait", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "blocks call until the currently running cleanup process has terminated", ""));
        CLIParser.CliOption oDir = new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "directory services to use (comma separated, e.g. 'pbrpc://localhost:32638',..)", "<uri>");
        oDir.urlDefaultPort = GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber();
        oDir.urlDefaultProtocol = "pbrpc";
        options.put("dir", oDir);
        options.put("v", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "run a version cleanup (only if file content versioning is enabled)", ""));
        CLIParser.parseCLI(args, options, arguments);
        if (options.get((Object)"h").switchValue.booleanValue() || options.get((Object)"-help").switchValue.booleanValue()) {
            xtfs_cleanup_osd.usage(options);
            return;
        }
        if (arguments.size() != 1) {
            xtfs_cleanup_osd.error("invalid number of arguments", options);
        }
        boolean remove = options.get((Object)"e").switchValue;
        boolean restore = options.get((Object)"r").switchValue;
        boolean deleteVolumes = options.get((Object)"delete_volumes").switchValue;
        boolean interactive = options.get((Object)"i").switchValue;
        boolean stop = options.get((Object)"stop").switchValue;
        boolean waitForFinish = options.get((Object)"wait").switchValue;
        boolean versionCleanup = options.get((Object)"v").switchValue;
        boolean removeMetadata = options.get((Object)"metadata_keep").switchValue == false;
        int metaDataTimeoutS = 600;
        if (options.get((Object)"metadata_timeout").numValue != null) {
            metaDataTimeoutS = options.get((Object)"metadata_timeout").numValue.intValue();
        }
        String[] dirURLs = options.get((Object)"dir").stringValue != null ? options.get((Object)"dir").stringValue.split(",") : null;
        password = options.get((Object)"-admin_password").stringValue != null ? options.get((Object)"-admin_password").stringValue : "";
        SSLOptions sslOptions = null;
        String[] dirAddrs = null;
        String osdUUID = null;
        if (((String)arguments.get(0)).startsWith("uuid:")) {
            osdUUID = ((String)arguments.get(0)).substring("uuid:".length());
        } else {
            xtfs_cleanup_osd.error("There was no UUID for the OSD given!", options);
        }
        if (dirURLs != null) {
            int i = 0;
            boolean gridSSL = false;
            dirAddrs = new String[dirURLs.length];
            for (String dirURL : dirURLs) {
                if (dirURL.contains("pbrpcs://") || dirURL.contains("pbrpcg://") && sslOptions == null) {
                    String serviceCredsFile = options.get((Object)"c").stringValue;
                    String serviceCredsPass = options.get((Object)"cpass").stringValue;
                    if (serviceCredsPass != null && serviceCredsPass.equals("-")) {
                        serviceCredsPass = new String(System.console().readPassword("Enter credentials password: ", new Object[0]));
                    }
                    String trustedCAsFile = options.get((Object)"t").stringValue;
                    String trustedCAsPass = options.get((Object)"tpass").stringValue;
                    if (trustedCAsPass != null && trustedCAsPass.equals("-")) {
                        trustedCAsPass = new String(System.console().readPassword("Enter trust store password: ", new Object[0]));
                    }
                    String sslProtocolString = options.get((Object)"-ssl-protocol").stringValue;
                    if (dirURL.contains("pbrpcg://")) {
                        gridSSL = true;
                    }
                    if (serviceCredsFile == null) {
                        System.out.println("SSL requires '-c' parameter to be specified");
                        xtfs_cleanup_osd.usage(options);
                        System.exit(1);
                    } else if (trustedCAsFile == null) {
                        System.out.println("SSL requires '-t' parameter to be specified");
                        xtfs_cleanup_osd.usage(options);
                        System.exit(1);
                    }
                    try {
                        sslOptions = new SSLOptions(new FileInputStream(serviceCredsFile), serviceCredsPass, "PKCS12", new FileInputStream(trustedCAsFile), trustedCAsPass, "JKS", false, gridSSL, sslProtocolString, null);
                    }
                    catch (Exception e) {
                        System.err.println("unable to get SSL options, because:" + e.getMessage());
                        System.exit(1);
                    }
                }
                if (dirURL.contains("://")) {
                    String[] tmp = dirURL.split("://");
                    dirAddrs[i++] = tmp[1].replace("/", "");
                    continue;
                }
                dirAddrs[i++] = dirURL.replace("/", "");
            }
        }
        if (dirURLs == null) {
            try {
                DefaultDirConfig cfg = new DefaultDirConfig();
                sslOptions = cfg.getSSLOptions();
                dirAddrs = cfg.getDirectoryServices();
            }
            catch (Exception e) {
                System.err.println("unable to get SSL options, because: " + e.getMessage());
                System.exit(1);
            }
        }
        if (remove && restore) {
            xtfs_cleanup_osd.error("Zombies cannot be deleted and restored at the same time!", options);
        }
        Options userOptions = new Options();
        RPC.UserCredentials userCredentials = RPC.UserCredentials.newBuilder().setUsername("root").addGroups("root").build();
        client = ClientFactory.createAdminClient(dirAddrs, userCredentials, sslOptions, userOptions);
        try {
            client.start();
        }
        catch (Exception e) {
            System.err.println("unable to cleanup OSD, because:" + e.getMessage());
            System.exit(1);
        }
        try {
            if (versionCleanup) {
                client.startVersionCleanUp(osdUUID, password);
            } else if (stop) {
                if (!client.isRunningCleanUp(osdUUID, password)) {
                    xtfs_cleanup_osd.error("No cleanup running on the given OSD.", options);
                }
                client.stopCleanUp(osdUUID, password);
                for (String result : client.getCleanUpResult(osdUUID, password)) {
                    System.out.println(result);
                }
                System.out.println("Cleanup stopped.");
            } else if (interactive) {
                if (client.isRunningCleanUp(osdUUID, password)) {
                    client.stopCleanUp(osdUUID, password);
                }
                client.startCleanUp(osdUUID, password, remove, deleteVolumes, restore, removeMetadata, metaDataTimeoutS);
                while (client.isRunningCleanUp(osdUUID, password)) {
                    System.out.print(client.getCleanUpState(osdUUID, password) + "\r");
                    Thread.sleep(3000L);
                }
                System.out.println();
                for (String result : client.getCleanUpResult(osdUUID, password)) {
                    System.out.println(result);
                }
                System.out.println("Cleanup done.");
            } else {
                if (client.isRunningCleanUp(osdUUID, password)) {
                    client.stopCleanUp(osdUUID, password);
                }
                client.startCleanUp(osdUUID, password, remove, deleteVolumes, restore, removeMetadata, metaDataTimeoutS);
                System.out.println("Cleanup is running.");
            }
            if (waitForFinish) {
                while (client.isRunningCleanUp(osdUUID, password)) {
                    Thread.sleep(5000L);
                }
                System.out.println("Cleanup done.");
            }
        }
        catch (Exception e) {
            System.err.println("error while running cleanup:" + e.getMessage());
            client.shutdown();
            System.exit(1);
        }
        client.shutdown();
        System.exit(0);
    }

    private static void error(String message, Map<String, CLIParser.CliOption> options) {
        System.err.println(message);
        System.out.println();
        xtfs_cleanup_osd.usage(options);
        System.exit(1);
    }

    public static void usage(Map<String, CLIParser.CliOption> options) {
        System.out.println("usage: xtfs_cleanup [options] uuid:<osd_uuid>\n");
        System.out.println("  <osd_uuid> the unique identifier of the OSD to clean\n");
        System.out.println("  options:");
        utils.printOptions(options);
    }
}

