/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils;

import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.PBRPCException;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.CLIParser;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.utils.utils;

public class xtfs_mrcdbtool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block36: {
            String op;
            Logging.start(3, new Logging.Category[0]);
            try {
                TimeSync.initializeLocal(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            Map<String, CLIParser.CliOption> options = utils.getDefaultAdminToolOptions(true);
            ArrayList<String> arguments = new ArrayList<String>(3);
            CLIParser.CliOption oMrc = new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.URL, "MRC to use (e.g. 'pbrpc://localhost:32636')", "<uri>");
            oMrc.urlDefaultPort = GlobalTypes.PORTS.MRC_PBRPC_PORT_DEFAULT.getNumber();
            oMrc.urlDefaultProtocol = "pbrpc";
            options.put("mrc", oMrc);
            try {
                CLIParser.parseCLI(args, options, arguments);
            }
            catch (Exception exc) {
                System.out.println(exc);
                xtfs_mrcdbtool.usage(options);
                System.exit(1);
            }
            CLIParser.CliOption h = options.get("h");
            CLIParser.CliOption help = options.get("-help");
            if (h.switchValue.booleanValue() || help.switchValue.booleanValue()) {
                xtfs_mrcdbtool.usage(options);
                System.exit(0);
            }
            CLIParser.CliOption mrc = options.get("mrc");
            if (mrc.urlValue == null) {
                System.out.println("missing MRC URL");
                xtfs_mrcdbtool.usage(options);
                System.exit(1);
            }
            if (arguments.size() < 2) {
                xtfs_mrcdbtool.usage(options);
                System.exit(1);
            }
            if (!"dump".equals(op = (String)arguments.get(0)) && !"restore".equals(op)) {
                System.out.println("invalid operation: " + op);
                xtfs_mrcdbtool.usage(options);
                System.exit(1);
            }
            String dumpFile = (String)arguments.get(1);
            CLIParser.CliOption c = options.get("c");
            String cp = options.get((Object)"cpass").stringValue;
            if (cp != null && cp.equals("-")) {
                cp = new String(System.console().readPassword("Enter credentials password: ", new Object[0]));
            }
            CLIParser.CliOption t = options.get("t");
            String tp = options.get((Object)"tpass").stringValue;
            if (tp != null && tp.equals("-")) {
                tp = new String(System.console().readPassword("Enter trust store password: ", new Object[0]));
            }
            String sslProtocolString = options.get((Object)"-ssl-protocol").stringValue;
            String host = mrc.urlValue.getHost();
            int port = mrc.urlValue.getPort();
            String protocol = mrc.urlValue.getProtocol();
            RPCNIOSocketClient rpcClient = null;
            try {
                SSLOptions sslOptions = null;
                boolean gridSSL = false;
                if (protocol.startsWith("pbrpcs") || protocol.startsWith("pbrpcg")) {
                    if (c.stringValue == null) {
                        System.out.println("SSL requires '-c' parameter to be specified");
                        xtfs_mrcdbtool.usage(options);
                        System.exit(1);
                    } else if (t.stringValue == null) {
                        System.out.println("SSL requires '-t' parameter to be specified");
                        xtfs_mrcdbtool.usage(options);
                        System.exit(1);
                    }
                    if (protocol.startsWith("pbrpcg")) {
                        gridSSL = true;
                    }
                    sslOptions = new SSLOptions(new FileInputStream(c.stringValue), cp, "PKCS12", new FileInputStream(t.stringValue), tp, "JKS", false, gridSSL, sslProtocolString, null);
                }
                rpcClient = new RPCNIOSocketClient(sslOptions, 2147482647, Integer.MAX_VALUE, "xtfs_mrcdbtool");
                rpcClient.start();
                MRCServiceClient client = new MRCServiceClient(rpcClient, new InetSocketAddress(host, port));
                RPC.Auth passwdAuth = RPCAuthentication.authNone;
                if (options.get((Object)"-admin_password").stringValue != null) {
                    passwdAuth = RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_PASSWORD).setAuthPasswd(RPC.AuthPassword.newBuilder().setPassword(options.get((Object)"-admin_password").stringValue)).build();
                }
                if (op.equals("dump")) {
                    RPCResponse r = null;
                    try {
                        r = client.xtreemfs_dump_database(null, passwdAuth, RPCAuthentication.userService, dumpFile);
                        r.get();
                        break block36;
                    }
                    finally {
                        if (r != null) {
                            r.freeBuffers();
                        }
                    }
                }
                if (op.equals("restore")) {
                    RPCResponse r = null;
                    try {
                        r = client.xtreemfs_restore_database(null, passwdAuth, RPCAuthentication.userService, dumpFile);
                        r.get();
                        break block36;
                    }
                    finally {
                        if (r != null) {
                            r.freeBuffers();
                        }
                    }
                }
                xtfs_mrcdbtool.usage(options);
                System.exit(1);
            }
            catch (PBRPCException exc) {
                if (exc.getPOSIXErrno() == RPC.POSIXErrno.POSIX_ERROR_EACCES) {
                    System.out.println("permission denied: admin password invalid or volumes exist already");
                } else {
                    exc.printStackTrace();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finally {
                if (rpcClient != null) {
                    rpcClient.shutdown();
                }
            }
        }
    }

    public static void usage(Map<String, CLIParser.CliOption> options) {
        System.out.println("usage: xtfs_mrcdbtool [options] dump|restore <dump_file>\n");
        System.out.println("  <dump_file> the file for the dump\n");
        System.out.println("  options:");
        utils.printOptions(options);
    }
}

