/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.CLIParser;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.drain.OSDDrain;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;
import org.xtreemfs.utils.DefaultDirConfig;
import org.xtreemfs.utils.utils;

public class xtfs_remove_osd {
    private OSDServiceClient osd;
    private DIRClient dir;
    private MRCServiceClient mrc;
    private RPCNIOSocketClient dirClient;
    private RPCNIOSocketClient osdClient;
    private RPCNIOSocketClient mrcClient;
    private InetSocketAddress osdAddr;
    private InetSocketAddress mrcAddr;
    private SSLOptions sslOptions;
    private String[] dirAddresses;
    private UUIDResolver resolver;
    private RPCNIOSocketClient resolverClient;
    private RPC.Auth authHeader;
    private RPC.UserCredentials credentials;
    private String osdUUIDString;
    private ServiceUUID osdUUID;

    public static void main(String[] args) {
        Map<String, CLIParser.CliOption> options = null;
        try {
            options = utils.getDefaultAdminToolOptions(true);
            ArrayList<String> arguments = new ArrayList<String>(1);
            CLIParser.CliOption oDir = new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "directory service to use (e.g. 'pbrpc://localhost:32638')", "<uri>");
            oDir.urlDefaultPort = GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber();
            oDir.urlDefaultProtocol = "pbrpc";
            options.put("dir", oDir);
            options.put("s", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "shutdown OSD", ""));
            options.put("d", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "enbable debug output", ""));
            CLIParser.parseCLI(args, options, arguments);
            if (options.get((Object)"d").switchValue.booleanValue()) {
                Logging.start(7, new Logging.Category[0]);
            } else {
                Logging.start(3, new Logging.Category[0]);
            }
            if (options.get((Object)"h").switchValue.booleanValue() || options.get((Object)"-help").switchValue.booleanValue() || arguments.size() == 0) {
                xtfs_remove_osd.usage(options);
                return;
            }
            if (arguments.size() > 1) {
                xtfs_remove_osd.error("invalid number of arguments", options, true);
            }
            boolean shutdown = options.get((Object)"s").switchValue;
            String password = options.get((Object)"-admin_password").stringValue != null ? options.get((Object)"-admin_password").stringValue : "";
            String[] dirURLs = options.get((Object)"dir").stringValue != null ? options.get((Object)"dir").stringValue.split(",") : null;
            String osdUUID = null;
            if (((String)arguments.get(0)).startsWith("uuid:")) {
                osdUUID = ((String)arguments.get(0)).substring("uuid:".length());
            } else {
                xtfs_remove_osd.error("There was no UUID for the OSD given!", options);
            }
            SSLOptions sslOptions = null;
            String[] dirAddrs = null;
            if (dirURLs != null) {
                int i = 0;
                boolean gridSSL = false;
                dirAddrs = new String[dirURLs.length];
                for (String dirURL : dirURLs) {
                    if (dirURL.contains("pbrpcs://") || dirURL.contains("pbrpcg://") && sslOptions == null) {
                        String serviceCredsFile = options.get((Object)"c").stringValue;
                        String serviceCredsPass = options.get((Object)"cpass").stringValue;
                        if (serviceCredsPass != null && serviceCredsPass.equals("-")) {
                            serviceCredsPass = new String(System.console().readPassword("Enter credentials password: ", new Object[0]));
                        }
                        String trustedCAsFile = options.get((Object)"t").stringValue;
                        String trustedCAsPass = options.get((Object)"tpass").stringValue;
                        if (trustedCAsPass != null && trustedCAsPass.equals("-")) {
                            trustedCAsPass = new String(System.console().readPassword("Enter trust store password: ", new Object[0]));
                        }
                        String sslProtocolString = options.get((Object)"-ssl-protocol").stringValue;
                        if (dirURL.contains("pbrpcg://")) {
                            gridSSL = true;
                        }
                        if (serviceCredsFile == null) {
                            System.out.println("SSL requires '-c' parameter to be specified");
                            xtfs_remove_osd.usage(options);
                            System.exit(1);
                        } else if (trustedCAsFile == null) {
                            System.out.println("SSL requires '-t' parameter to be specified");
                            xtfs_remove_osd.usage(options);
                            System.exit(1);
                        }
                        try {
                            sslOptions = new SSLOptions(new FileInputStream(serviceCredsFile), serviceCredsPass, "PKCS12", new FileInputStream(trustedCAsFile), trustedCAsPass, "JKS", false, gridSSL, sslProtocolString, null);
                        }
                        catch (Exception e) {
                            System.err.println("unable to get SSL options, because:" + e.getMessage());
                            System.exit(1);
                        }
                    }
                    if (dirURL.contains("://")) {
                        String[] tmp = dirURL.split("://");
                        dirAddrs[i++] = tmp[1].replace("/", "");
                        continue;
                    }
                    dirAddrs[i++] = dirURL.replace("/", "");
                }
            }
            if (dirURLs == null) {
                try {
                    DefaultDirConfig cfg = new DefaultDirConfig();
                    sslOptions = cfg.getSSLOptions();
                    dirAddrs = cfg.getDirectoryServices();
                }
                catch (Exception e) {
                    System.err.println("unable to get SSL options, because: " + e.getMessage());
                    System.exit(1);
                }
            }
            xtfs_remove_osd removeOsd = new xtfs_remove_osd(dirAddrs, osdUUID, sslOptions, password);
            removeOsd.initialize();
            removeOsd.drainOSD(shutdown);
            removeOsd.shutdown();
            System.exit(0);
        }
        catch (Exception e) {
            xtfs_remove_osd.error(e.getMessage(), options);
        }
    }

    public xtfs_remove_osd(String[] dirAddresses, String osdUUIDString, SSLOptions sslOptions, String password) throws Exception {
        try {
            this.sslOptions = sslOptions;
            this.dirAddresses = dirAddresses;
            this.osdUUIDString = osdUUIDString;
            this.authHeader = password.equals("") ? RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_NONE).build() : RPC.Auth.newBuilder().setAuthType(RPC.AuthType.AUTH_PASSWORD).setAuthPasswd(RPC.AuthPassword.newBuilder().setPassword(password).build()).build();
            this.credentials = RPC.UserCredentials.newBuilder().setUsername("root").addGroups("root").build();
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void initialize() throws Exception {
        TimeSync.initializeLocal(0);
        this.dirClient = new RPCNIOSocketClient(this.sslOptions, 10000, 300000, "xtfs_remove_osd (dir)");
        this.dirClient.start();
        this.dirClient.waitForStartup();
        String[] dirAddr = this.dirAddresses[0].split(":");
        InetSocketAddress dirSocketAddr = new InetSocketAddress(dirAddr[0], Integer.parseInt(dirAddr[1]));
        DIRServiceClient tmp = new DIRServiceClient(this.dirClient, dirSocketAddr);
        this.dir = new DIRClient(tmp, new InetSocketAddress[]{dirSocketAddr}, 100, 15000);
        this.resolverClient = new RPCNIOSocketClient(this.sslOptions, 10000, 300000, "xtfs_remove_osd (resolver)");
        this.resolverClient.start();
        this.resolverClient.waitForStartup();
        this.resolver = UUIDResolver.startNonSingelton(this.dir, 1000, 100000);
        this.osdUUID = new ServiceUUID(this.osdUUIDString, this.resolver);
        this.osdUUID.resolve();
        this.osdAddr = this.osdUUID.getAddress();
        this.osdClient = new RPCNIOSocketClient(this.sslOptions, 10000, 300000, "xtfs_remove_osd (osd)");
        this.osdClient.start();
        this.osdClient.waitForStartup();
        this.osd = new OSDServiceClient(this.osdClient, this.osdAddr);
        DIR.ServiceSet sSet = null;
        try {
            sSet = this.dir.xtreemfs_service_get_by_type(null, this.authHeader, this.credentials, DIR.ServiceType.SERVICE_TYPE_MRC);
        }
        catch (IOException ioe) {
            Logging.logMessage(4, Logging.Category.proc, new Object(), OutputUtils.stackTraceToString(ioe), new Object[0]);
            throw ioe;
        }
        this.mrcClient = new RPCNIOSocketClient(this.sslOptions, 100000, 3000000, "xtfs_remove_osd (mrc)");
        this.mrcClient.start();
        this.mrcClient.waitForStartup();
        if (sSet.getServicesCount() == 0) {
            throw new IOException("No MRC is currently registred at DIR");
        }
        String mrcUUID = sSet.getServices(0).getUuid();
        ServiceUUID UUIDService = new ServiceUUID(mrcUUID, this.resolver);
        UUIDService.resolve();
        this.mrcAddr = UUIDService.getAddress();
        this.mrc = new MRCServiceClient(this.mrcClient, this.mrcAddr);
    }

    public void shutdown() {
        try {
            this.resolverClient.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drainOSD(boolean shutdown) throws Exception {
        OSDDrain osdDrain = new OSDDrain(this.dir, this.osd, this.mrc, this.osdUUID, this.authHeader, this.credentials, this.resolver);
        osdDrain.drain(shutdown);
    }

    private static void error(String message, Map<String, CLIParser.CliOption> options, boolean printUsage) {
        System.err.println(message);
        if (printUsage) {
            System.out.println();
            xtfs_remove_osd.usage(options);
        }
        System.exit(1);
    }

    private static void error(String message, Map<String, CLIParser.CliOption> options) {
        xtfs_remove_osd.error(message, options, false);
    }

    public static void usage(Map<String, CLIParser.CliOption> options) {
        System.out.println("usage: xtfs_remove_osd [options] uuid:<osd_uuid>\n");
        System.out.println("  <osd_uuid> the unique identifier of the OSD to be removed\n");
        System.out.println("  options:");
        utils.printOptions(options);
    }
}

