/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils.xtfs_scrub;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xtreemfs.common.libxtreemfs.AdminFileHandle;
import org.xtreemfs.common.libxtreemfs.AdminVolume;
import org.xtreemfs.common.libxtreemfs.exceptions.AddressToUUIDNotFoundException;
import org.xtreemfs.common.libxtreemfs.exceptions.InvalidChecksumException;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.utils.xtfs_scrub.xtfs_scrub;

public class FileScrubber
implements Runnable {
    private AdminFileHandle fileHandle;
    private AdminVolume volume;
    private String fileName;
    private final xtfs_scrub.FileScrubbedListener listener;
    private long nextObjectToScrub;
    private long byteCounter;
    private final Set<String> removedOSDs;
    private Set<xtfs_scrub.ReturnStatus> returnStatus;
    private final boolean repair;
    private final boolean delete;
    private boolean isReadOnly;

    public FileScrubber(String fileName, AdminVolume volume, xtfs_scrub.FileScrubbedListener listener, Set<String> removedOSDs, boolean repair, boolean delete) throws PosixErrorException, AddressToUUIDNotFoundException, IOException {
        this.volume = volume;
        try {
            this.fileHandle = volume.openFile(xtfs_scrub.credentials, fileName, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDWR.getNumber());
            this.isReadOnly = false;
        }
        catch (PosixErrorException e) {
            this.fileHandle = volume.openFile(xtfs_scrub.credentials, fileName, GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_O_RDONLY.getNumber());
            this.isReadOnly = true;
        }
        this.fileName = fileName;
        this.listener = listener;
        this.returnStatus = new TreeSet<xtfs_scrub.ReturnStatus>();
        this.nextObjectToScrub = 0L;
        this.byteCounter = 0L;
        this.removedOSDs = removedOSDs;
        this.repair = repair;
        this.delete = delete;
    }

    @Override
    public void run() {
        String replicaUpdatePolicy = this.fileHandle.getReplicaUpdatePolicy();
        if (replicaUpdatePolicy.equals("ronly") && this.fileHandle.getReplicasList().size() > 1) {
            this.scrubReadOnlyReplicatedFile();
        } else {
            this.scrubRWOrNonReplicatedFile();
        }
        this.listener.fileScrubbed(this.fileName, this.byteCounter, this.returnStatus);
        try {
            this.fileHandle.close();
        }
        catch (IOException e) {
            this.printFileErrorMessage("unable to close file, because" + e);
        }
    }

    private void scrubReadOnlyReplicatedFile() {
        List<GlobalTypes.Replica> replicas = this.fileHandle.getReplicasList();
        long numObjs = 0L;
        boolean checkObjects = true;
        try {
            numObjs = this.fileHandle.getNumObjects(xtfs_scrub.credentials);
        }
        catch (IOException ex) {
            this.printFileErrorMessage("cannot get Number of Objects: " + ex);
            checkObjects = false;
            this.returnStatus.add(xtfs_scrub.ReturnStatus.UNREACHABLE);
        }
        LinkedList<GlobalTypes.Replica> removedReplicas = new LinkedList<GlobalTypes.Replica>();
        for (int r = 0; r < replicas.size(); ++r) {
            GlobalTypes.Replica replica = replicas.get(r);
            boolean isReplOnDeadOsd = false;
            for (String osd : replica.getOsdUuidsList()) {
                if (!this.removedOSDs.contains(osd)) continue;
                removedReplicas.add(replica);
                isReplOnDeadOsd = true;
                break;
            }
            if (!(checkObjects & !isReplOnDeadOsd)) continue;
            try {
                this.fileHandle.checkAndMarkIfReadOnlyReplicaComplete(r, xtfs_scrub.credentials);
            }
            catch (IOException ex) {
                this.printFileErrorMessage("cannot mark replica# " + r + " of file " + this.fileName + " as complete, because " + ex);
            }
            for (long o = 0L; o < numObjs; ++o) {
                try {
                    this.fileHandle.checkObjectAndGetSize(r, o);
                    continue;
                }
                catch (InvalidChecksumException ex) {
                    String errormsg = "";
                    if (this.repair) {
                        try {
                            this.fileHandle.repairObject(r, o);
                            errormsg = "object #" + o + " of replica " + r + " had an invalid checksum on OSD " + FileScrubber.getOSDUUIDFromObjectNo(replica, o) + " and was repaired";
                            this.returnStatus.add(xtfs_scrub.ReturnStatus.FAILURE_OBJECTS);
                        }
                        catch (IOException e) {
                            errormsg = "object #" + o + " of replica " + r + " has an invalid checksum on OSD " + FileScrubber.getOSDUUIDFromObjectNo(replica, o) + " and is irreparable";
                            this.returnStatus.add(xtfs_scrub.ReturnStatus.FAILURE_OBJECTS);
                        }
                    } else {
                        errormsg = "object #" + o + " of replica " + r + " has an invalid checksum on OSD " + FileScrubber.getOSDUUIDFromObjectNo(replica, o);
                        this.returnStatus.add(xtfs_scrub.ReturnStatus.FAILURE_OBJECTS);
                    }
                    this.printFileErrorMessage(errormsg);
                    continue;
                }
                catch (IOException ex) {
                    this.printFileErrorMessage("unable to check object #" + o + " of replica " + r + ": " + ex);
                    this.returnStatus.add(xtfs_scrub.ReturnStatus.UNREACHABLE);
                }
            }
        }
        if (!removedReplicas.isEmpty()) {
            if (this.repair) {
                this.recreateReplicas(removedReplicas);
            } else {
                this.printFileErrorMessage("lost " + removedReplicas.size() + " replicas due to dead OSDs");
            }
            this.returnStatus.add(xtfs_scrub.ReturnStatus.FAILURE_REPLICAS);
        }
        if (this.returnStatus.size() == 0) {
            this.returnStatus.add(xtfs_scrub.ReturnStatus.FILE_OK);
        }
    }

    private void scrubRWOrNonReplicatedFile() {
        List<GlobalTypes.Replica> replicas = this.fileHandle.getReplicasList();
        LinkedList<GlobalTypes.Replica> removedReplicas = new LinkedList<GlobalTypes.Replica>();
        block7: for (int r = 0; r < replicas.size(); ++r) {
            GlobalTypes.Replica replica = replicas.get(r);
            boolean isReplOnDeadOsd = false;
            for (String osd : replica.getOsdUuidsList()) {
                if (!this.removedOSDs.contains(osd)) continue;
                if (this.fileHandle.getReplicaUpdatePolicy().equals("") || this.fileHandle.getReplicasList().size() == 1) {
                    String errMsg = "file data was stored on removed OSD. File is lost.";
                    if (this.delete) {
                        errMsg = "file data was stored on removed OSD. File was deleted.";
                        try {
                            this.volume.unlink(xtfs_scrub.credentials, this.fileName);
                        }
                        catch (IOException ex2) {
                            errMsg = "unable to delete " + this.fileName + ", because: " + ex2.getMessage();
                        }
                    }
                    this.printFileErrorMessage(errMsg);
                    this.returnStatus.add(xtfs_scrub.ReturnStatus.FILE_LOST);
                    return;
                }
                removedReplicas.add(replica);
                isReplOnDeadOsd = true;
                break;
            }
            if (isReplOnDeadOsd) continue;
            boolean eof = false;
            this.nextObjectToScrub = 0L;
            while (!eof) {
                try {
                    int objSize;
                    if ((objSize = this.fileHandle.checkObjectAndGetSize(r, this.nextObjectToScrub++)) >= replica.getStripingPolicy().getStripeSize()) continue;
                    eof = true;
                }
                catch (InvalidChecksumException ex) {
                    this.printFileErrorMessage("object #" + (this.nextObjectToScrub - 1L) + " of replica " + r + " has an invalid checksum on OSD " + replica.getOsdUuids((int)((this.nextObjectToScrub - 1L) % (long)replica.getOsdUuidsCount())));
                    this.returnStatus.add(xtfs_scrub.ReturnStatus.FAILURE_OBJECTS);
                    continue block7;
                }
                catch (IOException ex) {
                    this.printFileErrorMessage("unable to check object #" + (this.nextObjectToScrub - 1L) + " of replica " + r + ": " + ex);
                    this.returnStatus.add(xtfs_scrub.ReturnStatus.UNREACHABLE);
                    continue block7;
                }
            }
        }
        if (!removedReplicas.isEmpty()) {
            if (this.repair) {
                this.recreateReplicas(removedReplicas);
            } else {
                this.printFileErrorMessage("lost " + removedReplicas.size() + " replicas due to dead OSDs");
            }
            this.returnStatus.add(xtfs_scrub.ReturnStatus.FAILURE_REPLICAS);
        }
        try {
            long mrcFileSize = this.volume.getAttr(xtfs_scrub.credentials, this.fileName).getSize();
            this.byteCounter = this.fileHandle.getSizeOnOSD();
            if (this.byteCounter != mrcFileSize) {
                if (this.repair) {
                    this.fileHandle.truncate(xtfs_scrub.credentials, this.byteCounter, true);
                    this.printFileErrorMessage("corrected file size from " + mrcFileSize + " to " + this.byteCounter + " bytes");
                } else {
                    this.printFileErrorMessage("incorrect file size: is " + mrcFileSize + " but should be " + this.byteCounter + " bytes");
                }
                this.returnStatus.add(xtfs_scrub.ReturnStatus.WRONG_FILE_SIZE);
            }
        }
        catch (IOException ex) {
            this.printFileErrorMessage("unable to get file size: " + ex);
            this.returnStatus.add(xtfs_scrub.ReturnStatus.UNREACHABLE);
        }
        if (this.returnStatus.size() == 0) {
            this.returnStatus.add(xtfs_scrub.ReturnStatus.FILE_OK);
        }
    }

    private void printFileErrorMessage(String error) {
        System.err.format("file '%s' (%s):\n\t%s\n", this.fileName, this.fileHandle.getGlobalFileId(), error);
    }

    private static String getOSDUUIDFromObjectNo(GlobalTypes.Replica replica, long objectNo) {
        return replica.getOsdUuids((int)objectNo % replica.getOsdUuidsCount());
    }

    private void recreateReplicas(List<GlobalTypes.Replica> removedReplicas) {
        int numReplRemoved = removedReplicas.size();
        int numNewReplicas = 0;
        for (GlobalTypes.Replica replica : removedReplicas) {
            List<String> osds;
            try {
                this.volume.removeReplica(xtfs_scrub.credentials, this.fileName, replica.getOsdUuids(0));
            }
            catch (IOException ex) {
                this.printFileErrorMessage("unable to remove replica of " + this.fileName + ", because: " + ex);
                continue;
            }
            try {
                osds = this.volume.getSuitableOSDs(xtfs_scrub.credentials, this.fileName, replica.getStripingPolicy().getWidth());
                if (osds.size() < replica.getStripingPolicy().getWidth()) {
                    this.printFileErrorMessage("cannot create new replica, not enough OSDs available");
                    continue;
                }
            }
            catch (IOException e) {
                this.printFileErrorMessage("cannot create new replicas, unable to get suitable OSDs");
                break;
            }
            GlobalTypes.Replica.Builder newReplicaBuilder = GlobalTypes.Replica.newBuilder();
            newReplicaBuilder.addAllOsdUuids(osds.subList(0, replica.getStripingPolicy().getWidth()));
            newReplicaBuilder.setReplicationFlags(replica.getReplicationFlags() & ~GlobalTypes.REPL_FLAG.REPL_FLAG_IS_COMPLETE.getNumber());
            newReplicaBuilder.setStripingPolicy(replica.getStripingPolicy());
            GlobalTypes.Replica newReplica = newReplicaBuilder.build();
            try {
                this.volume.addReplica(xtfs_scrub.credentials, this.fileName, newReplica);
                ++numNewReplicas;
            }
            catch (IOException ex) {
                this.printFileErrorMessage("cannot create new replica: " + ex);
            }
        }
        if (numNewReplicas == numReplRemoved) {
            this.printFileErrorMessage("lost " + numReplRemoved + " replicas due to dead OSDs. Created " + numReplRemoved + " new replicas.");
        } else {
            this.printFileErrorMessage("lost " + numReplRemoved + " replicas due to dead OSDs. Could only create " + numNewReplicas + " due to a lack of suitable OSDs or communication errors.");
        }
    }
}

