/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.utils.xtfs_scrub;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.xtreemfs.common.libxtreemfs.AdminClient;
import org.xtreemfs.common.libxtreemfs.AdminVolume;
import org.xtreemfs.common.libxtreemfs.ClientFactory;
import org.xtreemfs.common.libxtreemfs.Options;
import org.xtreemfs.common.libxtreemfs.exceptions.PosixErrorException;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.CLIParser;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.utils.DefaultDirConfig;
import org.xtreemfs.utils.utils;
import org.xtreemfs.utils.xtfs_scrub.FileScrubber;

public class xtfs_scrub {
    public static String latestScrubAttr = "scrubber.latestscrub";
    public static final RPC.UserCredentials credentials = RPC.UserCredentials.newBuilder().setUsername("root").addGroups("root").build();
    private static final int DEFAULT_NUM_THREADS = 10;
    private AdminVolume volume;
    private final boolean repair;
    private final boolean delete;
    private final boolean silent;
    private final ExecutorService tPool;
    private long lastBytesScrubbed;
    private final Stack<String> directories;
    private final Stack<String> files;
    private final Object completeLock;
    private int returnCode;
    private int numInFlight;
    private final int numThrs;
    private boolean hasFinished;
    private boolean isLatestScrubAttrSettable;
    private String currentDirName = null;
    private int numFiles;
    private int numReplicaFailure;
    private int numObjectFailure;
    private int numFileOk;
    private int numUnreachable;
    private int numWrongFS;
    private int numDead;
    private final Set<String> removedOSDs;

    public xtfs_scrub(AdminClient client, AdminVolume volume, int numThrs, boolean repair, boolean delete, boolean silent) throws IOException {
        this.repair = repair;
        this.delete = delete;
        this.silent = silent;
        this.numThrs = numThrs;
        this.directories = new Stack();
        this.files = new Stack();
        this.tPool = Executors.newFixedThreadPool(numThrs);
        this.numInFlight = 0;
        this.completeLock = new Object();
        this.hasFinished = false;
        this.isLatestScrubAttrSettable = true;
        this.volume = volume;
        this.numFiles = 0;
        this.numReplicaFailure = 0;
        this.numObjectFailure = 0;
        this.numFileOk = 0;
        this.numUnreachable = 0;
        if (!repair && !delete) {
            System.out.println("running in check mode, no changes to files will be made");
        } else {
            if (repair) {
                System.out.println("running in repair mode");
            }
            if (delete) {
                System.out.println("WARNING: delete is enabled, corrupt files (data lost due to failed OSDs) will be deleted");
            }
        }
        this.removedOSDs = client.getRemovedOsds();
        if (this.removedOSDs.size() > 0) {
            System.out.println("list of OSDs that have been removed (replicas on these OSDs will be deleted):");
            for (String uuid : this.removedOSDs) {
                System.out.println("\t" + uuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scrub() {
        System.out.println("");
        this.directories.push("/");
        try {
            this.volume.setXAttr(credentials, "/", latestScrubAttr, Long.toString(TimeSync.getLocalSystemTime()), MRC.XATTR_FLAGS.XATTR_FLAGS_CREATE);
        }
        catch (PosixErrorException e) {
        }
        catch (IOException e) {
            this.isLatestScrubAttrSettable = false;
            System.out.println("\nWarning: cannot mark volume as scrubbed: " + e);
        }
        this.fillQueue();
        Object e = this.completeLock;
        synchronized (e) {
            try {
                if (!this.hasFinished) {
                    this.completeLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.tPool.shutdown();
        try {
            this.tPool.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.silent) {
            System.out.format("scrubbed %-42s      %15s - total %15s\n\u001b[100D\u001b[A", "all files", "", OutputUtils.formatBytes(this.lastBytesScrubbed));
        }
        System.out.println("\n\nsummary:");
        System.out.println("files checked                                                   : " + this.numFiles);
        System.out.println("  files ok                                                      : " + this.numFileOk);
        System.out.println("  files corrupted                                               : " + (this.numFiles - this.numFileOk));
        System.out.println("    of which had lost replicas (caused by removed OSDs)         : " + this.numReplicaFailure);
        System.out.println("    of which had corrupted objects (caused by invalid checksums): " + this.numObjectFailure);
        System.out.println("    of which had a wrong file size                              : " + this.numWrongFS);
        System.out.println("    of which are lost (unrecoverable)                           : " + this.numDead);
        System.out.println("    of which are unreachable (caused by communication errors)   : " + this.numUnreachable);
        System.out.println("bytes checked                                                   : " + OutputUtils.formatBytes(this.lastBytesScrubbed));
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillQueue() {
        try {
            Stack<String> stack = this.directories;
            synchronized (stack) {
                while (this.numInFlight < this.numThrs) {
                    try {
                        String fileName = this.files.pop();
                        try {
                            FileScrubbedListener fsListener = new FileScrubbedListener(){

                                @Override
                                public void fileScrubbed(String fileName, long bytesScrubbed, Collection<ReturnStatus> rstatus) {
                                    xtfs_scrub.this.fileScrubbed(fileName, bytesScrubbed, rstatus);
                                }
                            };
                            FileScrubber fi = new FileScrubber(fileName, this.volume, fsListener, this.removedOSDs, this.repair, this.delete);
                            this.tPool.submit(fi);
                            ++this.numInFlight;
                        }
                        catch (IOException ex) {
                            Logging.logError(4, this, ex);
                        }
                    }
                    catch (EmptyStackException ex) {
                        this.fetchNextDir();
                    }
                }
                return;
            }
        }
        catch (EmptyStackException ex) {
            if (this.isLatestScrubAttrSettable) {
                try {
                    this.volume.setXAttr(credentials, "/", latestScrubAttr, Long.toString(TimeSync.getLocalSystemTime()), MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE);
                }
                catch (IOException ex2) {
                    System.out.println("\nWarning: cannot mark volume as successfully scrubbed: " + ex2);
                }
            }
            this.finish(0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int returnCode) {
        Stack<String> stack = this.directories;
        synchronized (stack) {
            if (this.numInFlight == 0) {
                Object object = this.completeLock;
                synchronized (object) {
                    this.returnCode = returnCode;
                    this.hasFinished = true;
                    this.completeLock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileScrubbed(String fileName, long bytesScrubbed, Collection<ReturnStatus> rs) {
        if (fileName.length() > 42) {
            fileName = "..." + fileName.substring(fileName.length() - 39, fileName.length());
        }
        Stack<String> stack = this.directories;
        synchronized (stack) {
            this.lastBytesScrubbed += bytesScrubbed;
            ++this.numFiles;
            for (ReturnStatus status : rs) {
                switch (status) {
                    case FILE_OK: {
                        ++this.numFileOk;
                        break;
                    }
                    case WRONG_FILE_SIZE: {
                        ++this.numWrongFS;
                        break;
                    }
                    case UNREACHABLE: {
                        ++this.numUnreachable;
                        break;
                    }
                    case FILE_LOST: {
                        ++this.numDead;
                        break;
                    }
                    case FAILURE_REPLICAS: {
                        ++this.numReplicaFailure;
                        break;
                    }
                    case FAILURE_OBJECTS: {
                        ++this.numObjectFailure;
                    }
                }
            }
            if (!this.silent) {
                System.out.format("scrubbed %-42s with %15s - total %15s\n\u001b[100D\u001b[A", fileName, OutputUtils.formatBytes(bytesScrubbed), OutputUtils.formatBytes(this.lastBytesScrubbed));
            }
            --this.numInFlight;
            this.fillQueue();
        }
    }

    private void fetchNextDir() {
        this.currentDirName = this.directories.pop();
        try {
            MRC.DirectoryEntries ls = this.volume.readDir(credentials, this.currentDirName, 0, 0, false);
            if (ls == null) {
                Logging.logMessage(3, this, "path %s does not exist!", this.currentDirName);
                return;
            }
            for (int i = 0; i < ls.getEntriesCount(); ++i) {
                MRC.DirectoryEntry e = ls.getEntries(i);
                if ((e.getStbuf().getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFREG.getNumber()) != 0) {
                    this.files.push(this.currentDirName + e.getName());
                    continue;
                }
                if ((e.getStbuf().getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFDIR.getNumber()) == 0 || e.getName().equals(".") || e.getName().equals("..")) continue;
                this.directories.push(this.currentDirName + e.getName() + "/");
            }
        }
        catch (IOException ex) {
            System.err.println("cannot contact MRC... aborting");
            System.err.println(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EmptyStackException();
        }
    }

    public static void main(String[] args) {
        Logging.start(4, new Logging.Category[0]);
        System.out.println("XtreemFS scrubber version 1.5.0-master (file system data integrity check)\n");
        Map<String, CLIParser.CliOption> options = utils.getDefaultAdminToolOptions(false);
        ArrayList<String> arguments = new ArrayList<String>(1);
        CLIParser.CliOption oDir = new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.STRING, "directory service to use (e.g. 'pbrpc://localhost:32638'). If no URI is specified, URI and security settings are taken from '/etc/xos/xtreemfs/default_dir'", "<uri>");
        oDir.urlDefaultPort = GlobalTypes.PORTS.DIR_PBRPC_PORT_DEFAULT.getNumber();
        oDir.urlDefaultProtocol = "pbrpc";
        options.put("dir", oDir);
        options.put("repair", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "repair files (update file size, replace replicas) when possible", ""));
        options.put("delete", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "delete lost files (incomplete due to OSD failures)", ""));
        options.put("silent", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.SWITCH, "don't show the progress bar", ""));
        options.put("thrs", new CLIParser.CliOption(CLIParser.CliOption.OPTIONTYPE.NUMBER, "number of concurrent file scrub threads (default=10)", "n"));
        CLIParser.parseCLI(args, options, arguments);
        if (arguments.size() != 1) {
            xtfs_scrub.error("invalid number of arguments", options);
        }
        if (options.get((Object)"h").switchValue.booleanValue() || options.get((Object)"-help").switchValue.booleanValue()) {
            xtfs_scrub.usage(options);
            System.exit(0);
        }
        String[] dirURLs = options.get((Object)"dir").stringValue != null ? options.get((Object)"dir").stringValue.split(",") : null;
        SSLOptions sslOptions = null;
        String[] dirAddrs = null;
        if (dirURLs != null) {
            int i = 0;
            boolean gridSSL = false;
            dirAddrs = new String[dirURLs.length];
            for (String dirURL : dirURLs) {
                if (dirURL.contains("pbrpcs://") || dirURL.contains("pbrpcg://") && sslOptions == null) {
                    String serviceCredsFile = options.get((Object)"c").stringValue;
                    String serviceCredsPass = options.get((Object)"cpass").stringValue;
                    if (serviceCredsPass != null && serviceCredsPass.equals("-")) {
                        serviceCredsPass = new String(System.console().readPassword("Enter credentials password: ", new Object[0]));
                    }
                    String trustedCAsFile = options.get((Object)"t").stringValue;
                    String trustedCAsPass = options.get((Object)"tpass").stringValue;
                    if (trustedCAsPass != null && trustedCAsPass.equals("-")) {
                        trustedCAsPass = new String(System.console().readPassword("Enter trust store password: ", new Object[0]));
                    }
                    String sslProtocolString = options.get((Object)"-ssl-protocol").stringValue;
                    if (dirURL.contains("pbrpcg://")) {
                        gridSSL = true;
                    }
                    if (serviceCredsFile == null) {
                        System.out.println("SSL requires '-c' parameter to be specified");
                        xtfs_scrub.usage(options);
                        System.exit(1);
                    } else if (trustedCAsFile == null) {
                        System.out.println("SSL requires '-t' parameter to be specified");
                        xtfs_scrub.usage(options);
                        System.exit(1);
                    }
                    try {
                        sslOptions = new SSLOptions(new FileInputStream(serviceCredsFile), serviceCredsPass, "PKCS12", new FileInputStream(trustedCAsFile), trustedCAsPass, "JKS", false, gridSSL, sslProtocolString, null);
                    }
                    catch (Exception e) {
                        System.err.println("unable to set up SSL, because:" + e.getMessage());
                        System.exit(1);
                    }
                }
                if (dirURL.contains("://")) {
                    String[] tmp = dirURL.split("://");
                    dirAddrs[i++] = tmp[1].replace("/", "");
                    continue;
                }
                dirAddrs[i++] = dirURL.replace("/", "");
            }
        }
        if (dirURLs == null) {
            try {
                DefaultDirConfig cfg = new DefaultDirConfig();
                sslOptions = cfg.getSSLOptions();
                dirAddrs = cfg.getDirectoryServices();
            }
            catch (Exception e) {
                System.err.println("unable to get SSL options, because: " + e.getMessage());
                System.exit(1);
            }
        }
        boolean repair = options.get((Object)"repair").switchValue;
        boolean silent = options.get((Object)"silent").switchValue;
        boolean delete = options.get((Object)"delete").switchValue;
        int numThreads = 10;
        if (options.get((Object)"thrs").numValue != null) {
            numThreads = options.get((Object)"thrs").numValue.intValue();
        }
        String volumeName = (String)arguments.get(0);
        Options userOptions = new Options();
        AdminClient c = ClientFactory.createAdminClient(dirAddrs, credentials, sslOptions, userOptions);
        AdminVolume volume = null;
        try {
            c.start();
            volume = c.openVolume(volumeName, sslOptions, new Options());
            volume.start();
        }
        catch (Exception e) {
            System.err.println("unable to scrub Volume, because: " + e.getMessage());
            System.exit(1);
        }
        int exitCode = 1;
        try {
            xtfs_scrub scrubber = new xtfs_scrub(c, volume, numThreads, repair, delete, silent);
            exitCode = scrubber.scrub();
            if (exitCode == 0) {
                System.out.println("\n\nsuccessfully scrubbed volume '" + volumeName + "'");
            } else {
                System.out.println("\n\nscrubbing volume '" + volumeName + "' FAILED!");
            }
            System.exit(exitCode);
        }
        catch (Exception e) {
            System.err.println("unable to scrub Volume, because: " + e.getMessage());
            System.exit(1);
        }
        c.shutdown();
    }

    private static void error(String message, Map<String, CLIParser.CliOption> options) {
        System.err.println(message);
        System.out.println();
        xtfs_scrub.usage(options);
        System.exit(1);
    }

    private static void usage(Map<String, CLIParser.CliOption> options) {
        System.out.println("usage: xtfs_scrub [options] <volume_name>");
        System.out.println("<volume_name> the volume to scrub\n");
        System.out.println("options:");
        utils.printOptions(options);
    }

    public static enum ReturnStatus {
        FILE_OK,
        FILE_LOST,
        WRONG_FILE_SIZE,
        FAILURE_OBJECTS,
        FAILURE_REPLICAS,
        UNREACHABLE;

    }

    public static interface FileScrubbedListener {
        public void fileScrubbed(String var1, long var2, Collection<ReturnStatus> var4);
    }
}

